import subprocess
from pathlib import Path

# Directory where this script lives
base_dir = Path(__file__).resolve().parent
images_dir = base_dir / "images"
images_dir.mkdir(exist_ok=True)

mp4_files = base_dir.glob("*.mp4")

for mp4 in mp4_files:
    output = images_dir / f"{mp4.stem}.webp"

    cmd = [
        "ffmpeg",
        "-y",                     # overwrite if exists
        "-i", str(mp4),
        "-vf", "thumbnail",
        "-frames:v", "1",
        "-c:v", "libwebp",
        "-quality", "75",
        str(output)
    ]

    subprocess.run(cmd, check=True)

print("Done.")
