//  Copyright: Erik Hjelmvik <hjelmvik@users.sourceforge.net>
//
//  NetworkMiner is free software; you can redistribute it and/or modify it
//  under the terms of the GNU General Public License
//
//  Contact Erik Hjelmvik if you wish to use NetworkMiner commersially
using System;
using System.Collections.Generic;
using System.Text;
using System.Collections;


namespace NetworkWrapper {

    /// <summary>
    /// Based on:
    /// "Packet sniffing with Winpcap functions ported to a .NET library"
    /// By Victor Tan. 
    /// 
    /// http://www.codeproject.com/dotnet/dotnetwinpcap.asp
    /// </summary>
    public class WinPCapSniffer: ISniffer {
        private dotnetWinpCap wpcap;
        private int nPacketsReceived;

        public static event PacketReceivedHandler PacketReceived;

        //callback-funktion fr att ta emot paket frn dotnetWinpCap
        private void ReceivePacketListener(object sender, PacketHeader ph, byte[] data) {
            nPacketsReceived++;
            PacketReceivedEventArgs eventArgs=new PacketReceivedEventArgs(data, ph.TimeStamp, PacketReceivedEventArgs.PacketTypes.Ethernet2Packet);
            PacketReceived(this, eventArgs);
            /*
            this.pack_count++;
            rtb.Focus();
            rtb.AppendText("Content of p : \n");
            rtb.AppendText("	Caplength: "+p.Caplength+"\n");
            rtb.AppendText("	Length   : "+p.Length+"\n");
            rtb.AppendText("	Timestamp: "+ (p.TimeStamp)+"\n");
            labPacketCnt.Text=Convert.ToString(this.pack_count);
             * */

        }

        //constructor
        public WinPCapSniffer(WinPCapAdapter adapter) {
            nPacketsReceived=0;
            wpcap=new dotnetWinpCap();
            if(wpcap.IsOpen)
                wpcap.Close();

            //Opens an Ethernet interface with
            //source as the name of the interface obtained from a Device object,
            //snaplen is the max number of bytes to be captured from each packet,
            //flags=1 means promiscuous mode,
            //read_timeout is the blocking time of ReadNext before it returns.
            if(!wpcap.Open(adapter.NPFName, 65536, 1, 0))
                throw new Exception(wpcap.LastError);

            //sets the minimum number of bytes required to be received by the driver before
            //OnReceivePacket fires. Lowering this can increase response time,
            //but increases system calls which lowers program efficiency.
            wpcap.SetMinToCopy(100);

            dotnetWinpCap.ReceivePacket rcvPack=new dotnetWinpCap.ReceivePacket(this.ReceivePacketListener);
            wpcap.OnReceivePacket+=rcvPack;
        }
        
        //destructor
        ~WinPCapSniffer() {
            wpcap.Close();
        }

        public void StartSniffing() {
            wpcap.StartListen();
        }
        public void StopSniffing() {
            wpcap.StopListen();
            //wpcap.Close();
        }
        

    }
}
