//  Copyright: Erik Hjelmvik <hjelmvik@users.sourceforge.net>
//
//  NetworkMiner is free software; you can redistribute it and/or modify it
//  under the terms of the GNU General Public License
//
//  Contact Erik Hjelmvik if you wish to use NetworkMiner commersially
using System;
using System.Collections.Generic;
using System.Text;

namespace NetworkWrapper {
    public class WinPCapAdapter : IAdapter{
        private string npfName;// for example "\Device\NPF_{XXXXX}"
        private string description;//for example "3Com EtherLink PCI"
        private string ipAddress;//The IP-address
        private string netmask;//For example 255.255.255.0 ???

        internal string NPFName { get { return this.npfName; } }

        internal WinPCapAdapter(Device device){
            this.ipAddress=device.Address;
            this.description=device.Description;
            this.npfName=device.Name;
            this.netmask=device.Netmask;
        }

        public override string ToString() {
            return "WinPcap: "+this.description+" "+npfName.Substring(12);
        }

        public static List<IAdapter> GetAdapters() {
            System.Collections.ArrayList tmpList;
            //try {
                tmpList=dotnetWinpCap.FindAllDevs();
            /*} catch(System.Exception.DllNotFoundException ddlEx){
                throw new Exception("WinPcap is not installed", ddlEx);
            } catch{
                tmpList=new System.Collections.ArrayList();
            }*/
            List<IAdapter> devices=new List<IAdapter>(tmpList.Count);

            foreach(object d in tmpList) {
                devices.Add(new WinPCapAdapter((Device)d));
            }
            return devices;
        }
    }
}
