//  Copyright: Erik Hjelmvik <hjelmvik@users.sourceforge.net>
//
//  NetworkMiner is free software; you can redistribute it and/or modify it
//  under the terms of the GNU General Public License
//
//  Contact Erik Hjelmvik if you wish to use NetworkMiner commersially
using System;
using System.Collections.Generic;
using System.Text;
//using System.Net;
using System.Net.Sockets;
using System.Net;

namespace NetworkWrapper{
    public class SocketSniffer : ISniffer{

        private Socket socket;
        private byte[] buffer;
        bool snifferActive;

        public static event PacketReceivedHandler PacketReceived;

        public SocketSniffer(SocketAdapter adapter) {
            this.snifferActive=false;
            buffer=new byte[65535];
            socket=new Socket(AddressFamily.InterNetwork, SocketType.Raw, ProtocolType.IP);
            //m_Monitor = new Socket(AddressFamily.InterNetwork, SocketType.Raw, ProtocolType.IP);

            IPEndPoint endPoint=new IPEndPoint(adapter.IP, 0);
            socket.Bind(endPoint);
            byte[] optionInValue={1,0,0,0};
            socket.IOControl(IOControlCode.ReceiveAll, optionInValue, null);

            //m_Monitor.Bind(new IPEndPoint(IP, 0));
            //m_Monitor.IOControl(SIO_RCVALL, BitConverter.GetBytes((int)1), null);
            //m_Monitor.BeginReceive(m_Buffer, 0, m_Buffer.Length, SocketFlags.None, new AsyncCallback(this.OnReceive), null);
        }

        public void StartSniffing() {
            IAsyncResult sniffResult=socket.BeginReceive(buffer, 0, buffer.Length, SocketFlags.None, new AsyncCallback(this.ReceivePacketListener), null);
            this.snifferActive=true;
            //result.
        
        }

        public void StopSniffing() {
            //socket.EndReceive(null);
            this.snifferActive=false;

        }

        //destructor
        ~SocketSniffer() {
            socket.Close();
        }

        private void ReceivePacketListener(IAsyncResult result) {
            //try {
                int received = socket.EndReceive(result);
                try {
                    byte[] data = new byte[received];
                    Array.Copy(buffer, 0, data, 0, received);
                    PacketReceivedEventArgs eventArgs=new PacketReceivedEventArgs(data, DateTime.Now, PacketReceivedEventArgs.PacketTypes.IPv4Packet);
                    PacketReceived(this, eventArgs);

                    //OnNewPacket(new Packet(packet));
                }
                catch { } // invalid packet; ignore
            if(this.snifferActive)
                socket.BeginReceive(buffer, 0, buffer.Length, SocketFlags.None, new AsyncCallback(this.ReceivePacketListener), null);
           // }
            //catch {
                //Stop();
            //}
        }
    }
}
