//  Copyright: Erik Hjelmvik <hjelmvik@users.sourceforge.net>
//
//  NetworkMiner is free software; you can redistribute it and/or modify it
//  under the terms of the GNU General Public License
//
//  Contact Erik Hjelmvik if you wish to use NetworkMiner commersially
using System;
using System.Collections.Generic;
using System.Text;
using System.Net;
using System.Net.NetworkInformation;

namespace NetworkWrapper {
    public class SocketAdapter : IAdapter{
        private IPAddress ip;
        System.Net.NetworkInformation.NetworkInterface nic;

        public IPAddress IP{get{return ip;}}

        /*SocketAdapter(IPAddress ip) {
            this.ip=ip;
        }*/
        SocketAdapter(NetworkInterface nic) {
            this.nic=nic;
            UnicastIPAddressInformationCollection ipAddressCollection=nic.GetIPProperties().UnicastAddresses;
            if (ipAddressCollection.Count > 0)
                this.ip = ipAddressCollection[0].Address;
            else this.ip = IPAddress.None;

        }

        public override string ToString() {
            //return "Socket: "+ip.ToString();
            return "Socket: "+nic.Description+" ("+ip.ToString()+")";
        }

        public static List<IAdapter> GetAdapters() {
            //IPAddress[] ipAdresses=Dns.Resolve(Dns.GetHostName()).AddressList;
            //IPAddress[] ipAdresses=Dns.GetHostEntry(Dns.GetHostName()).AddressList;
            NetworkInterface[] nics=NetworkInterface.GetAllNetworkInterfaces();
            List<IAdapter> adapters=new List<IAdapter>(nics.Length);

            foreach(NetworkInterface nic in nics) {
                adapters.Add(new SocketAdapter(nic));
            }
            return adapters;
        }
    }
}
