//  Copyright: Erik Hjelmvik <hjelmvik@users.sourceforge.net>
//
//  NetworkMiner is free software; you can redistribute it and/or modify it
//  under the terms of the GNU General Public License
//
//  Contact Erik Hjelmvik if you wish to use NetworkMiner commersially
using System;
using System.Collections.Generic;
using System.Text;

namespace NetworkWrapper {
    //public delegate void PacketReceivedHandler(object sender, DateTime timestamp, byte[] data);

    //based on: http://www.codeproject.com/csharp/csevents01.asp
    public class PacketReceivedEventArgs : EventArgs {

        public enum PacketTypes { Ethernet2Packet, IPv4Packet };

        private byte[] data;
        private DateTime timestamp;
        private PacketTypes packetType;
        
        //private int capLength;
        //private int length;

        public DateTime Timestamp { get { return timestamp; } }
        public byte[] Data { get { return data; } }
        public PacketTypes PacketType { get { return packetType; } }
        //public int CapLength { get { return capLength; } }//denna behvs nog inte
        //public int Length { get { return length; } }

        public PacketReceivedEventArgs(byte[] data, DateTime timestamp/*, int length*/, PacketTypes packetType) {
            this.data=data;
            //this.timestamp=ph.TimeStamp;
            this.timestamp=timestamp;
            //this.capLength=ph.Caplength;
            //this.length=ph.Length;
            //this.length=length;
            this.packetType=packetType;
        }

    }

    public delegate void PacketReceivedHandler(object sender, PacketReceivedEventArgs e);

}
