using System;
using System.Collections.Generic;
using System.Text;

namespace NetworkMiner.Packets {
    /// <summary>
    /// I'm just doing a very simple implementation of the SSDP Notify command here
    /// So I just extract all the lines (fields) and add them to a collection
    /// </summary>
    class UpnpPacket : AbstractPacket {
        private List<string> fieldList;

        internal List<string> FieldList { get { return this.fieldList; } }

        internal UpnpPacket(Frame parentFrame, int packetStartIndex, int packetEndIndex)
            : base(parentFrame, packetStartIndex, packetEndIndex, "UPnP") {
            this.fieldList=new List<string>();
            int dataIndex=packetStartIndex;
            string line;
            while(dataIndex<packetEndIndex) {
                line=ByteConverter.ReadLine(parentFrame.Data, ref dataIndex);
                if(line.Length>0)
                    fieldList.Add(line);
                else
                    break;
            }
        }

        internal override IEnumerable<AbstractPacket> GetSubPackets() {
            //Do nothing, no known sub packets...
            yield break;
        }
    }
}
