using System;
using System.Collections.Generic;
using System.Text;

namespace NetworkMiner.Packets {
    //http://ubiqx.org/cifs/SMB.html see: 2.1.2 NBT or Not NBT

    class NetBiosSessionService : NetBiosPacket {

        internal enum MessageTypes : byte { SessionMessage=0x00, SessionRequest=0x81, PositiveSessionResponse=0x82 }

        private byte messageType;
        private int length;

        private bool raw;//True if SMB should run directly over TCP, False if NetBIOS over TCP/IP is disabled

        internal byte MessageType { get { return this.messageType; } }
        internal int Length { get { return this.length; } }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="parentFrame"></param>
        /// <param name="packetStartIndex"></param>
        /// <param name="packetEndIndex"></param>
        internal NetBiosSessionService(Frame parentFrame, int packetStartIndex, int packetEndIndex, bool raw)
        //internal NetBiosSessionService(Frame parentFrame, int packetStartIndex, int packetEndIndex)
            : base(parentFrame, packetStartIndex, packetEndIndex, "NetBIOS Session Service") {
            this.messageType=parentFrame.Data[packetStartIndex];
            //this.raw=raw;
            uint l=ByteConverter.ToUInt32(parentFrame.Data, packetStartIndex);
            if(raw)
                this.length=(int)(l&0x00ffffff);//get the last 3 bytes (24 bits)
            else
                this.length=(int)(l&0x0001ffff);//get the last 17 bits
            this.Attributes.Add("Length", length.ToString());

        }

        internal override IEnumerable<AbstractPacket> GetSubPackets() {

            if(this.messageType==0x00 && PacketStartIndex+4<PacketEndIndex) {
                AbstractPacket packet;

                try {
                    packet=new CifsPacket(ParentFrame, PacketStartIndex+4, PacketEndIndex);
                }
                catch {
                    packet=new RawPacket(ParentFrame, PacketStartIndex+4, PacketEndIndex);
                }

                yield return packet;

                foreach(AbstractPacket subPacket in packet.GetSubPackets())
                    yield return subPacket;
            }

        }
    }
}
