//  Copyright: Erik Hjelmvik <hjelmvik@users.sourceforge.net>
//
//  NetworkMiner is free software; you can redistribute it and/or modify it
//  under the terms of the GNU General Public License
//
//  Contact Erik Hjelmvik if you wish to use NetworkMiner commersially
using System;
using System.Collections.Generic;
using System.Text;

namespace NetworkMiner.Packets {

    //NetBIOS Name Service
    //http://gogloom.com/CowCulture?rfcnum=1002&RFCtitle=4.2.1.++GENERAL+FORMAT+OF+NAME+SERVICE+PACKETS
    //http://ubiqx.org/cifs/NetBIOS.html
    //http://www.faqs.org/rfcs/rfc1002.html
    class NetBiosNameServicePacket : NetBiosPacket {

        internal class HeaderFlags {
            internal enum OperationCodes : byte { query=0, registration=5, release=6, WACK=7, refresh=8 };

            private ushort headerData;
            //private static uint OpcodeMask=0x7000;

            internal bool Response { get { return (headerData&0x8000)==0x8000; } }
            internal byte OperationCode { get { return (byte)((headerData>>11)&0x000F); } }
            internal byte NmFlags { get { return (byte)((headerData>>4)&0x007F); } }
            internal byte ResultCode { get { return (byte)(headerData&0x000F); } }

            internal HeaderFlags(ushort value) {
                this.headerData=value;
            }
        }

        //header
        private ushort transactionID;

        private HeaderFlags headerFlags;
        //private bool responseOperation;
        //private byte operationCode;//(OPCODE) nibble
        //private byte nmFlags;//7bits
        //private byte resultCode;//(RCODE) nibble
        private ushort questionCount;//Unsigned 16 bit integer specifying the number of entries in the question section of a Name
        private ushort answerCount;
        private ushort authorityCount;
        private ushort additionalCount;

        //question section
        //internal byte[] questionName;//ends with 0x00 (usually starts with 0x20)
        private string questionNameDecoded;//The NetBIOS name which is queried for...
        private ushort questionType;//NB == 0x0020, NBSTAT == 0x0021
        private ushort questionClass;//Internet Class: 0x0001

        
        private string answerNameDecoded;
        private ushort answerType;
        private ushort answerClass;
        private uint answerTTL;
        private ushort answerDataLength;
        private ushort answerFlags;
        private System.Net.IPAddress answerAddress;


        internal string QueriedNetBiosName { get { return this.questionNameDecoded; } }

        internal System.Net.IPAddress AnsweredIpAddress { get { return this.answerAddress; } }
        internal string AnsweredNetBiosName { get { return this.answerNameDecoded; } }
        

        //internal ushort SourcePort { get { return sourcePort; } }
        //internal ushort DestinationPort { get { return destinationPort; } }


        internal NetBiosNameServicePacket(Frame parentFrame, int packetStartIndex, int packetEndIndex)
            : base(parentFrame, packetStartIndex, packetEndIndex, "NetBIOS Name Service") {
            //header
            this.transactionID=ByteConverter.ToUInt16(parentFrame.Data, packetStartIndex);
            this.headerFlags=new HeaderFlags(ByteConverter.ToUInt16(parentFrame.Data, packetStartIndex+2));
            this.questionCount=ByteConverter.ToUInt16(parentFrame.Data, packetStartIndex+4);
            this.answerCount=ByteConverter.ToUInt16(parentFrame.Data, packetStartIndex+6);
            this.authorityCount=ByteConverter.ToUInt16(parentFrame.Data, packetStartIndex+8);
            this.additionalCount=ByteConverter.ToUInt16(parentFrame.Data, packetStartIndex+10);

            int i=packetStartIndex+12;
            this.questionNameDecoded=null;
            for(int q=0; q<questionCount; q++) {//I'll just assume that there is only one question... otherwise it will be overwritten
                //StringBuilder decodedName=new StringBuilder("");

                //get a NetBIOS name label
                this.questionNameDecoded=NetBiosPacket.DecodeNetBiosName(parentFrame, ref i);

                //Get Question Type
                this.questionType=ByteConverter.ToUInt16(parentFrame.Data, i);
                i+=2;

                //Get Question Class
                this.questionClass=ByteConverter.ToUInt16(parentFrame.Data, i);
                i+=2;
            }

            this.answerNameDecoded=null;
            this.answerAddress=new System.Net.IPAddress((long)0);
            //ANSWER RESOURCE RECORDS
            for(int a=0; a<answerCount;a++) {
                this.answerNameDecoded=NetBiosPacket.DecodeNetBiosName(parentFrame, ref i);
                //Get Question Type
                this.answerType=ByteConverter.ToUInt16(parentFrame.Data, i);
                i+=2;
                //Get Question Class
                this.answerClass=ByteConverter.ToUInt16(parentFrame.Data, i);
                i+=2;
                //TTL
                this.answerTTL=ByteConverter.ToUInt32(parentFrame.Data, i);
                i+=4;
                //data length
                this.answerDataLength=ByteConverter.ToUInt16(parentFrame.Data, i);
                i+=2;
                //flags
                this.answerFlags=ByteConverter.ToUInt16(parentFrame.Data, i);
                i+=2;
                //addr
                byte[] ipBytes=new byte[4];//IP4...
                Array.Copy(parentFrame.Data, i, ipBytes, 0, ipBytes.Length);
                this.answerAddress=new System.Net.IPAddress(ipBytes);
                i+=4;
            }
                            
            //this one is not quite finished yeat...
            //AUTHORITY RESOURCE RECORDS    

        }
        /*
        internal override List<Packet> GetSubPackets() {
            List<Packet> subPackets=new List<Packet>();
            if(PacketStartIndex+8<PacketEndIndex) {
                RawPacket rawPacket=new RawPacket(ParentFrame, PacketStartIndex+8, PacketEndIndex);
                //ParentFrame.Packets.Add(rawPacket.PacketStartIndex+internetHeaderLength, rawPacket);
                subPackets.Add(rawPacket);
                subPackets.AddRange(rawPacket.GetSubPackets());
            }
            return subPackets;
        }
         * */
        internal override IEnumerable<AbstractPacket> GetSubPackets() {
            //List<Packet> subPackets=new List<Packet>();
            if(PacketStartIndex+8<PacketEndIndex) {
                RawPacket rawPacket=new RawPacket(ParentFrame, PacketStartIndex+8, PacketEndIndex);
                //ParentFrame.Packets.Add(rawPacket.PacketStartIndex+internetHeaderLength, rawPacket);
                yield return rawPacket;
                foreach(AbstractPacket subPacket in rawPacket.GetSubPackets())
                    yield return subPacket;
            }
            //return subPackets;
        }
    }
}
