//  Copyright: Erik Hjelmvik <hjelmvik@users.sourceforge.net>
//
//  NetworkMiner is free software; you can redistribute it and/or modify it
//  under the terms of the GNU General Public License
//
//  Contact Erik Hjelmvik if you wish to use NetworkMiner commersially
using System;
using System.Collections.Generic;
using System.Text;

namespace NetworkMiner.Packets {

    //http://en.wikipedia.org/wiki/IPv4
    class IPv4Packet : AbstractPacket {
        internal enum RFC790Protocols : byte { ICMP=0x01, IGMP=0x02, TCP=0x06, Telnet=0x0E, UDP=0x11, OSPF=0x59, SCTP=0x84};

        //byte[] sourceMAC, destinationMAC;
        System.Net.IPAddress sourceIP, destinationIP;
        bool dontFragmentFlag;
        bool moreFragmentsFlag;
        byte timeToLive;
        byte protocol;
        byte internetHeaderByteCount;
        ushort totalLength;

        //lgg till checksum!

        //public byte[] SourceMACAddress { get { return this.sourceMAC;}}
        //public byte[] DestinationMACAddress {get {return this.destinationMAC;}}


        internal System.Net.IPAddress SourceIPAddress { get { return sourceIP; } }
        internal System.Net.IPAddress DestinationIPAddress {get{return destinationIP;}}
        internal ushort TotalLength { get { return totalLength; } }
        internal bool DontFragmentFlag { get { return dontFragmentFlag; } }//needed for OS fingerprinting
        internal byte TimeToLive { get { return timeToLive; } }//needed for OS fingerprinting

        /*detta r fr TCP:
        internal int SourceTCPPort { get { return 256*data[EthernetFrameOffset+34]+data[EthernetFrameOffset+35]; } }
        internal int DestinationTCPPort { get { return 256*data[EthernetFrameOffset+36]+data[EthernetFrameOffset+37]; } }

        */

        //jag behver kanske inte denna konsruktor?
        internal IPv4Packet(Frame parentFrame, int packetStartIndex, int packetEndIndex) : base(parentFrame, packetStartIndex, packetEndIndex, "IPv4") {
            //version = 4 (offset 0)
            if((parentFrame.Data[packetStartIndex]>>4)!=0x04)
                parentFrame.Errors.Add(new Frame.Error(parentFrame, packetStartIndex, packetStartIndex, "IP Version!=4 ("+(parentFrame.Data[packetStartIndex]>>4)+")"));
            //try {
                //Internet Header Length (IHL)  (offset=0,5)
            this.internetHeaderByteCount=(byte)(4*(parentFrame.Data[packetStartIndex]&(byte)0x0F));
            if(internetHeaderByteCount<20)
                parentFrame.Errors.Add(new Frame.Error(parentFrame, packetStartIndex, packetStartIndex, "Too short defined IPv4 field HeaderLength"));
            else if(packetStartIndex+internetHeaderByteCount>packetEndIndex+1)
                parentFrame.Errors.Add(new Frame.Error(parentFrame, packetStartIndex, packetStartIndex, "Too long defined IPv4 field HeaderLength"));

            //Total Length (offset=2)
            this.totalLength=ByteConverter.ToUInt16(parentFrame.Data, packetStartIndex+2);
            this.Attributes.Add("Total Length", totalLength.ToString());

            if(totalLength!=packetEndIndex-packetStartIndex+1) {
                //the ethernet packet has to be at least 60 bytes. so there might be some padding (ethernet trailer) here
                //http://mirror.ethereal.com/lists/ethereal-users/200012/msg00114.html
                if(totalLength>46)//if the parent frame still is longer even though the IP packet fills out the ethernet packet, then there is something wrong
                    parentFrame.Errors.Add(new Frame.Error(parentFrame, packetStartIndex+2, packetStartIndex+3, "IPv4 TotalLength field ("+totalLength+") does not match packet length ("+(packetEndIndex-packetStartIndex+1)+")"));

                //I'll adjust the IPv4 packet length since it shall be shorter
                if(totalLength<packetEndIndex-packetStartIndex+1)
                    base.PacketEndIndex=packetStartIndex+totalLength-1;
            }

            //Flags (offset=6)
            this.dontFragmentFlag=((parentFrame.Data[packetStartIndex+6]&0x40)==0x40);
            this.moreFragmentsFlag=((parentFrame.Data[packetStartIndex+6]&0x20)==0x20);

            //this.Attributes.Add("Total Length3", (packetEndIndex-packetStartIndex+1).ToString());
            //TTL (offset=8)
            this.timeToLive=parentFrame.Data[packetStartIndex+8];
            this.Attributes.Add("TTL", timeToLive.ToString());
            
            this.protocol=parentFrame.Data[packetStartIndex+9];
            //source (offset=12)
            byte[] sourceIpBytes=new byte[4];//jag antar IP4 n s lnge...
            Array.Copy(parentFrame.Data, packetStartIndex+12, sourceIpBytes, 0, sourceIpBytes.Length);
            this.sourceIP=new System.Net.IPAddress(sourceIpBytes);
            this.Attributes.Add("Source IP", sourceIP.ToString());
            //destination (offset=16)
            byte[] destinationIpBytes=new byte[4];//jag antar IP4 n s lnge...
            Array.Copy(parentFrame.Data, packetStartIndex+16, destinationIpBytes, 0, destinationIpBytes.Length);
            this.destinationIP=new System.Net.IPAddress(destinationIpBytes);
            this.Attributes.Add("Destination IP", destinationIP.ToString());
                
           // }
            //catch{}
        }


        /*
        internal override List<Packet>  GetSubPackets(){
            List<Packet> subPackets=new List<Packet>();
            if(PacketStartIndex+internetHeaderByteCount<PacketEndIndex) {
                if(this.protocol==(byte)IPv4Packet.RFC790Protocols.TCP) {
                    //TCP packet
                    TcpPacket tcpPacket=new TcpPacket(this.ParentFrame, PacketStartIndex+internetHeaderByteCount, PacketEndIndex);//bugg?
                    subPackets.Add(tcpPacket);
                    subPackets.AddRange(tcpPacket.GetSubPackets());
                }
                else if(this.protocol==(byte)IPv4Packet.RFC790Protocols.UDP) {
                    //UDP packet
                    UdpPacket udpPacket=new UdpPacket(this.ParentFrame, PacketStartIndex+internetHeaderByteCount, PacketEndIndex);
                    subPackets.Add(udpPacket);
                    subPackets.AddRange(udpPacket.GetSubPackets());
                }
                else {
                    RawPacket rawPacket=new RawPacket(ParentFrame, PacketStartIndex+internetHeaderByteCount, PacketEndIndex);
                    //ParentFrame.Packets.Add(rawPacket.PacketStartIndex+internetHeaderLength, rawPacket);
                    subPackets.Add(rawPacket);
                    subPackets.AddRange(rawPacket.GetSubPackets());
                }
            }
            //kolla om det r ett TCP-paket

            //s lnge s fr allt vara RawPacket
            return subPackets;
        }
        */
        internal override IEnumerable<AbstractPacket> GetSubPackets() {
            if(PacketStartIndex+internetHeaderByteCount<PacketEndIndex) {
                AbstractPacket packet;
                if(this.protocol==(byte)IPv4Packet.RFC790Protocols.TCP) {
                    //TCP packet
                    packet=new TcpPacket(this.ParentFrame, PacketStartIndex+internetHeaderByteCount, PacketEndIndex);//bugg?                   
                }
                else if(this.protocol==(byte)IPv4Packet.RFC790Protocols.UDP) {
                    //UDP packet
                    packet=new UdpPacket(this.ParentFrame, PacketStartIndex+internetHeaderByteCount, PacketEndIndex);
                }
                else {
                    packet=new RawPacket(ParentFrame, PacketStartIndex+internetHeaderByteCount, PacketEndIndex);
                }
                yield return packet;
                foreach(AbstractPacket subPacket in packet.GetSubPackets())
                    yield return subPacket;
            }
        }

        /*
        public override string ToString() {
            StringBuilder sbDataReceived=new StringBuilder();
            char c;
            for(int byteCounter=54; byteCounter+EthernetFrameOffset<data.Length && byteCounter<256; byteCounter++) {
                c=(char)data[EthernetFrameOffset+byteCounter];
                if(Char.IsLetterOrDigit(c) || Char.IsSymbol(c) || Char.IsWhiteSpace(c))
                    sbDataReceived.Append(c);
                else
                    sbDataReceived.Append(".");
            }
            return sbDataReceived.ToString();
        }
         * */

    }
}
