//  Copyright: Erik Hjelmvik <hjelmvik@users.sourceforge.net>
//
//  NetworkMiner is free software; you can redistribute it and/or modify it
//  under the terms of the GNU General Public License
//
//  Contact Erik Hjelmvik if you wish to use NetworkMiner commersially
using System;
using System.Collections.Generic;
using System.Text;
using System.Net.NetworkInformation;

namespace NetworkMiner.Packets {

    //http://en.wikipedia.org/wiki/Ethernet#Ethernet_frame_types_and_the_EtherType_field
    //http://en.wikipedia.org/wiki/DIX
    class Ethernet2Packet : AbstractPacket {
        internal enum EtherTypes : ushort { ARP=0x0806, IPv4=0x0800, IEEE802_3_Max=0x0600 };
        //private const int EthernetFrameOffset=20;//det var 26 innan???
        //private byte[] packetData;//the data for the ethernet packet...
        //byte[] sourceMAC, destinationMAC;
        PhysicalAddress sourceMAC, destinationMAC;

        ushort etherType;// (must be larger than 0x0600, otherwise Ether v.1) 0x0800 = IP, 0x0806 = ARP



        public PhysicalAddress SourceMACAddress { get { return this.sourceMAC; } }//OBS: Source och desination verkar ha bytt plats!!!
        public PhysicalAddress DestinationMACAddress { get { return this.destinationMAC; } }

        /*
         * Allt detta r fr IP-paket...
        internal System.Net.IPAddress SourceIPAddress{
            get{
                byte[] ipBytes=new byte[4];//jag antar IP4 n s lnge...

                for(int i=0; i<4; i++)
                    ipBytes[i]=data[EthernetFrameOffset+26+i];
                return new System.Net.IPAddress(ipBytes);

            }
        }

        internal System.Net.IPAddress DestinationIPAddress {
            get {
                byte[] ipBytes=new byte[4];//jag antar IP4 n s lnge...

                for(int i=0; i<4; i++)
                    ipBytes[i]=data[EthernetFrameOffset+30+i];
                return new System.Net.IPAddress(ipBytes);

            }
        }
        internal byte TimeToLive { get { return data[EthernetFrameOffset+22]; } }
         * */

        /*detta r fr TCP:
        internal int SourceTCPPort { get { return 256*data[EthernetFrameOffset+34]+data[EthernetFrameOffset+35]; } }
        internal int DestinationTCPPort { get { return 256*data[EthernetFrameOffset+36]+data[EthernetFrameOffset+37]; } }

        */

        //jag behver kanske inte denna konsruktor?
        internal Ethernet2Packet(Frame parentFrame, int packetStartIndex, int packetEndIndex) : base(parentFrame, packetStartIndex, packetEndIndex, "Ethernet2") {
            this.etherType=ByteConverter.ToUInt16(parentFrame.Data, packetStartIndex+12);
                //(ushort)(256*parentFrame.Data[12]+parentFrame.Data[13]);
            if(this.etherType<=(ushort)Ethernet2Packet.EtherTypes.IEEE802_3_Max)
                parentFrame.Errors.Add(new Frame.Error(parentFrame, packetStartIndex+12, packetStartIndex+13, "Not Ethernet v2 (EtherType<=0x0600)"));

            byte[] tmpDestinationMAC=new byte[6];
            Array.Copy(parentFrame.Data, packetStartIndex, tmpDestinationMAC, 0, tmpDestinationMAC.Length);
            this.destinationMAC=new PhysicalAddress(tmpDestinationMAC);
            //this.Attributes.Add("Destination MAC", ConvertToHexString(destinationMAC));
            this.Attributes.Add("Destination MAC", this.destinationMAC.ToString());

            byte[] tmpSourceMAC=new byte[6];
            Array.Copy(parentFrame.Data, packetStartIndex+6, tmpSourceMAC, 0, tmpSourceMAC.Length);
            this.sourceMAC=new PhysicalAddress(tmpSourceMAC);
            //this.Attributes.Add("Source MAC", ConvertToHexString(sourceMAC));
            this.Attributes.Add("Source MAC", this.sourceMAC.ToString());
        }

        private string ConvertToHexString(byte[] data) {
            StringBuilder str=new StringBuilder();
            for(int i=0; i<data.Length-1; i++) {
                str.Append(data[i].ToString("X2")+"-");
            }
            str.Append(data[data.Length-1].ToString("X2"));
            return str.ToString();
        }

        /*
        internal override List<Packet>  GetSubPackets(){
            //kolla om det r ett IPv4
            List<Packet> subPackets=new List<Packet>();
            if(PacketStartIndex+14<PacketEndIndex) {
                if(this.ParentFrame.Data[PacketStartIndex+12]==0x08 && this.ParentFrame.Data[PacketStartIndex+13]==0x00) {
                    //IPv4 packet
                    IPv4Packet ipPacket=new IPv4Packet(this.ParentFrame, PacketStartIndex+14, PacketEndIndex);
                    subPackets.Add(ipPacket);
                    subPackets.AddRange(ipPacket.GetSubPackets());
                    //this.ParentFrame.Packets.Add(ipPacket.PacketStartIndex, ipPacket);
                }
                else if(this.ParentFrame.Data[PacketStartIndex+12]==0x08 && this.ParentFrame.Data[PacketStartIndex+13]==0x06) {
                    ArpPacket arpPacket=new ArpPacket(this.ParentFrame, PacketStartIndex+14, PacketEndIndex);
                    subPackets.Add(arpPacket);
                    subPackets.AddRange(arpPacket.GetSubPackets());
                    //ARP-packet
                }
                else {
                    //something else
                    RawPacket rawPacket=new RawPacket(this.ParentFrame, PacketStartIndex+14, PacketEndIndex);
                    //ParentFrame.Packets.Add(rawPacket.PacketStartIndex+14, rawPacket);
                    subPackets.Add(rawPacket);
                    subPackets.AddRange(rawPacket.GetSubPackets());
                }
                //s lnge s fr allt vara RawPacket
            }
            return subPackets;
        }
         * */
        internal override IEnumerable<AbstractPacket> GetSubPackets() {
            if(PacketStartIndex+14<PacketEndIndex) {
                AbstractPacket packet;
                if(this.ParentFrame.Data[PacketStartIndex+12]==0x08 && this.ParentFrame.Data[PacketStartIndex+13]==0x00) {
                    //IPv4 packet
                    packet=new IPv4Packet(this.ParentFrame, PacketStartIndex+14, PacketEndIndex);
                }
                else if(this.ParentFrame.Data[PacketStartIndex+12]==0x08 && this.ParentFrame.Data[PacketStartIndex+13]==0x06) {
                    packet=new ArpPacket(this.ParentFrame, PacketStartIndex+14, PacketEndIndex);
                    //ARP-packet
                }
                else {
                    //something else
                    packet=new RawPacket(this.ParentFrame, PacketStartIndex+14, PacketEndIndex);
                }
                yield return packet;
                foreach(AbstractPacket subPacket in packet.GetSubPackets())
                    yield return subPacket;
            }
        }

    }
}
