using System;
using System.Collections.Generic;
using System.Text;

namespace NetworkMiner {
    class NetworkCredential : IComparable<NetworkCredential>{

        private NetworkHost host;
        private string protocolString;
        private string username;
        private string password;
        private bool isProvenValid;//this one shall only be set to true if you are sure that the user+pass is valid

        internal NetworkHost Host { get { return this.host; } }
        internal string ProtocolString { get { return this.protocolString; } }
        internal string Username { get { return this.username; } }
        internal string Password { get { return this.password; } }
        internal bool IsProvenValid { get { return this.isProvenValid; } set { this.isProvenValid=value; } }


        internal NetworkCredential(NetworkHost host, string protocolString, string username, string password) {
            this.host=host;
            this.protocolString=protocolString;
            this.username=username;
            this.password=password;
            this.isProvenValid=false;
        }


        public override string ToString() {
            return host.ToString()+" "+protocolString+" "+username+" "+password;
        }

        #region IComparable<NetworkCredential> Members

        public int CompareTo(NetworkCredential other) {
            return this.ToString().CompareTo(other.ToString());
        }

        #endregion
    }
}
