//  Copyright: Erik Hjelmvik <hjelmvik@users.sourceforge.net>
//
//  NetworkMiner is free software; you can redistribute it and/or modify it
//  under the terms of the GNU General Public License
//
//  Contact Erik Hjelmvik if you wish to use NetworkMiner commersially
using System;
using System.Collections.Generic;
using System.Text;

namespace NetworkMiner {
    class Frame {
        //private static int nFramesReceived;

        private int frameNumber;//eller long?
        private DateTime timestamp;
        //private int length;
        private byte[] data;
        private SortedList<int, Packets.AbstractPacket> packetList;
        private List<Error> errorList;

        public int FrameNumber { get { return frameNumber; } }
        public DateTime Timestamp { get { return timestamp; } }
        //public int Length { get { return length; } }
        public byte[] Data { get { return data; } }
        public SortedList<int, Packets.AbstractPacket> PacketList { get { return packetList; } }
        //public List<Error> ErrorList { get { return errorList; } }
        public IList<Error> Errors {
            get {
                return errorList;
            //foreach(Error er in errorList)
              //  yield return er;
            }
        }

        //public string PacketTypeDescription { get { return "Frame Metadata"; } }
        //public IPacket ParentPacket { get { return null; } }

        //public Frame(int frameNumber, DateTime timestamp, byte[] data, System.Type packetType) {
        public Frame(DateTime timestamp, byte[] data, System.Type packetType, int frameNumber) {
            this.frameNumber=frameNumber;
            //this.frameNumber=nFramesReceived;
            //nFramesReceived++;

            this.timestamp=timestamp;
            //this.length=length;
            this.data=data;
            this.errorList=new List<Error>();
            this.packetList=new SortedList<int, Packets.AbstractPacket>();
            //try {
            if(packetType.Equals(typeof(Packets.Ethernet2Packet))) {
                Packets.Ethernet2Packet ethernetPacket= new Packets.Ethernet2Packet(this, 0, data.Length-1);
                packetList.Add(ethernetPacket.PacketStartIndex, ethernetPacket);
                foreach(Packets.AbstractPacket p in ethernetPacket.GetSubPackets())
                    if(packetList.ContainsKey(p.PacketStartIndex))
                        packetList[p.PacketStartIndex]=p;
                    else
                        packetList.Add(p.PacketStartIndex, p);
            }
            else if(packetType.Equals(typeof(Packets.IPv4Packet))) {
                Packets.IPv4Packet ipPacket= new Packets.IPv4Packet(this, 0, data.Length-1);
                packetList.Add(ipPacket.PacketStartIndex, ipPacket);
                foreach(Packets.AbstractPacket p in ipPacket.GetSubPackets())
                    if(packetList.ContainsKey(p.PacketStartIndex))
                        packetList[p.PacketStartIndex]=p;
                    else
                        packetList.Add(p.PacketStartIndex, p);
            }
           // }
            //catch { }
        }

        public override string ToString() {
            return "Frame "+frameNumber+" ["+timestamp.ToString()+"]";
        }

        internal class Error {
            private Frame frame;
            private int errorStartIndex;
            private int errorEndIndex;
            private string description;


            internal Error(Frame frame, int errorStartIndex, int errorEndIndex, string description) {
                this.frame=frame;
                this.errorStartIndex=errorStartIndex;
                this.errorEndIndex=errorEndIndex;
                this.description=description;
            }

            public override string ToString() {
                StringBuilder sb=new StringBuilder(description+", ["+errorStartIndex+","+errorEndIndex+"] :");
                for(int i=errorStartIndex;i<=errorEndIndex;i++)
                    sb.Append(" "+frame.Data[errorStartIndex].ToString("X2"));
                return sb.ToString();
            }
        }
    }
}
