//  Copyright: Erik Hjelmvik <hjelmvik@users.sourceforge.net>
//
//  NetworkMiner is free software; you can redistribute it and/or modify it
//  under the terms of the GNU General Public License
//
//  Contact Erik Hjelmvik if you wish to use NetworkMiner commersially
using System;
using System.Collections.Generic;
using System.Text;
using System.IO;

namespace NetworkMiner.Fingerprints {
    class MacCollection {
        private static MacCollection singletonInstance=null;

        internal static MacCollection GetMacCollection() {
            if(singletonInstance==null)
                singletonInstance=new MacCollection("nmap-mac-prefixes", MacFingerprintFileFormat.Nmap);
                //singletonInstance=new MacCollection(etter.finger.mac, MacFingerprintFileFormat.Ettercap);
            return singletonInstance;
        }

        private System.Collections.Generic.SortedDictionary<string, string> macDictionary;
        internal enum MacFingerprintFileFormat { Ettercap, Nmap }

        /// <summary>
        /// Reads a fingerprint file wit NIC MAC addresses. The file shall be formatted according to Ettercap
        /// </summary>
        /// <param name="macFingerprintFilename">for example "etter.finger.mac"</param>
        private MacCollection(string macFingerprintFilename, MacFingerprintFileFormat format) {
            //System.IO.File.OpenRead(macFingerprintFilename)
            //Environment.GetFolderPath(Environment.SpecialFolder.LocalApplicationData)
            //Environment.CurrentDirectory;

            System.IO.FileStream fileStream=new FileStream(Path.GetDirectoryName(System.Windows.Forms.Application.ExecutablePath)+"\\"+macFingerprintFilename, FileMode.Open, FileAccess.Read);
            StreamReader reader=new StreamReader(fileStream);
            
            macDictionary=new SortedDictionary<string, string>();

            while(!reader.EndOfStream){
                string line=reader.ReadLine();
                //see if it is an empty or commented line
                if(line[0]!='#'){
                    string macKey=null;
                    string vendor=null;
                    if(format==MacFingerprintFileFormat.Ettercap && line.Length>10) {
                        macKey=line.Substring(0,8);//for example 00:00:01
                        vendor=line.Substring(10);
                    }
                    else if(format==MacFingerprintFileFormat.Nmap && line.Length>7) {
                        macKey=line.Substring(0, 2)+":"+line.Substring(2, 2)+":"+line.Substring(4, 2);
                        vendor=line.Substring(7);
                    }
                    if(macKey!=null && vendor!=null && !macDictionary.ContainsKey(macKey))
                        macDictionary.Add(macKey, vendor);
                    //hashTable.Add(mac, vendor);
                }
            }
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="macAddress">shall be in hex format. For example "00:F3:A1"</param>
        /// <returns></returns>
        internal string GetMacVendor(string macAddress){
            string macKey=macAddress.Substring(0, 2)+":"+macAddress.Substring(3, 2)+":"+macAddress.Substring(6, 2);
            if(macDictionary.ContainsKey(macKey))
                return macDictionary[macKey];
            else
                return "Unknown";

        }
        internal string GetMacVendor(System.Net.NetworkInformation.PhysicalAddress macAddress) {
            return GetMacVendor(macAddress.GetAddressBytes());
        }
        internal string GetMacVendor(byte[] macAddress) {
            return GetMacVendor(macAddress[0].ToString("X2")+":"+macAddress[1].ToString("X2")+":"+macAddress[2].ToString("X2"));
        }
        
    }
}
