using System;
using System.Collections.Generic;
using System.Text;

namespace NetworkMiner.Fingerprints {
    interface IOsFingerprintCollection {

        /// <summary>
        /// Guesses the OS based on TCP and IP packet structures
        /// </summary>
        /// <param name="ipv4Packet">IP packet of a SYN packet</param>
        /// <param name="tcpPacket">TCP packet of a SYN request</param>
        /// <returns>An array with string of the guessed OS's. The array will be empty if no likely OS's are found.</returns>
        string[] GetOperatingSystems(Packets.IPv4Packet ipv4Packet, Packets.TcpPacket tcpPacket);
        byte GetTtlDistance(Packets.IPv4Packet ipv4Packet, Packets.TcpPacket tcpPacket);
        byte GetTtlDistance(byte ipv4PacketTimeToLive);
    }
}
