using System;
using System.Collections.Generic;
using System.Text;

namespace NetworkMiner.FileTransfer {
    class ReconstructedFile {

        private string path, details;
        private NetworkHost sourceHost, destinationHost;
        private ushort sourcePort, destinationPort;
        private bool tcpTransfer;
        private FileStreamTypes fileStreamType;
        private long fileSize;

        private string filename;

        internal string FilePath { get { return this.path; } }
        internal NetworkHost SourceHost { get { return this.sourceHost; } }
        internal string SourcePortString { get { return this.GetTransportProtocolString()+" "+sourcePort; } }
        internal NetworkHost DestinationHost { get { return this.destinationHost; } }
        internal string DestinationPortString { get { return this.GetTransportProtocolString()+" "+destinationPort; } }
        internal string Filename { get { return this.filename; } }
        internal string FileSizeString {
            get {
                //return string.Format(new 
                System.Globalization.NumberFormatInfo nfi=new System.Globalization.NumberFormatInfo();
                nfi.NumberDecimalDigits=0;
                nfi.NumberGroupSizes=new int[] {3};
                nfi.NumberGroupSeparator=" ";
                //nfi.
                return this.fileSize.ToString("N", nfi)+" B";
            } }
        internal string Details { get { return this.details; } }
        internal FileStreamTypes FileStreamType { get { return this.fileStreamType; } }

        private string GetFileEnding() {
            if(!filename.Contains("."))
                return "";
            if(filename.EndsWith("."))
                return "";
            return this.filename.Substring(filename.LastIndexOf('.')+1).ToLower();
        }

        internal bool IsImage() {
            string fileEnding=GetFileEnding();
            if(fileEnding.Length==0)
                return false;
            if(fileEnding=="jpg" || fileEnding=="jpeg" || fileEnding=="gif" || fileEnding=="png" || fileEnding=="bmp" || fileEnding=="tif" || fileEnding=="tiff")
                return true;
            else
                return false;
        }

        internal bool IsIcon() {
            string fileEnding=GetFileEnding();
            if(fileEnding.Length==0)
                return false;
            if(fileEnding=="ico")
                return true;
            else
                return false;
        }



        internal ReconstructedFile(string path, NetworkHost sourceHost, NetworkHost destinationHost, ushort sourcePort, ushort destinationPort, bool tcpTransfer, FileStreamTypes fileStreamType, string details) {
            this.path=path;
            try {
                this.filename=path.Substring(path.LastIndexOf('/')+1);
            }
            catch(Exception e) {
                this.filename="";
            }
            this.sourceHost=sourceHost;
            this.destinationHost=destinationHost;
            this.sourcePort=sourcePort;
            this.destinationPort=destinationPort;
            this.tcpTransfer=tcpTransfer;
            this.fileStreamType=fileStreamType;
            this.details=details;

            System.IO.FileInfo fi=new System.IO.FileInfo(path);
            this.fileSize=fi.Length;
        }

        private string GetTransportProtocolString() {
            if(this.tcpTransfer)
                return "TCP";
            else
                return "UDP";
        }

        public override string ToString() {
            string sourceInfo;
            string destinationInfo;
            if(tcpTransfer) {
                sourceInfo=sourceHost.ToString()+" TCP "+sourcePort;
                destinationInfo=destinationHost.ToString()+" TCP "+destinationPort;
            }
            else {
                sourceInfo=sourceHost.ToString()+" UDP "+sourcePort;
                destinationInfo=destinationHost.ToString()+" UDP "+destinationPort;
            }

            return filename+"\t"+sourceInfo+"\t"+destinationInfo;

        }
    }
}
