/*************************************************************************
* ADOBE CONFIDENTIAL
* ___________________
*
*  Copyright 2015 Adobe Systems Incorporated
*  All Rights Reserved.
*
* NOTICE:  All information contained herein is, and remains
* the property of Adobe Systems Incorporated and its suppliers,
* if any.  The intellectual and technical concepts contained
* herein are proprietary to Adobe Systems Incorporated and its
* suppliers and are protected by all applicable intellectual property laws,
* including trade secret and or copyright laws.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from Adobe Systems Incorporated.
**************************************************************************/
import{dcLocalStorage as t}from"../common/local-storage.js";import{loggingApi as a}from"../common/loggingApi.js";import{POPUP_CONTEXT as e}from"../common/constant.js";const r=new class{constructor(){this.storageKey="dynamicTabContextMap",this.isInitialized=!1}async init(){if(!this.isInitialized)try{await t.init(),this.setupEventListeners(),this.isInitialized=!0}catch(t){a.error({message:"DynamicTabContextManager: Error during initialization",error:t})}}getDynamicTabContextMap(){try{return t.getItem(this.storageKey)||{}}catch(t){return a.error({message:"DynamicTabContextManager: Error getting dynamic tab context map",error:t}),{}}}saveDynamicTabContextMap(e){try{t.setItem(this.storageKey,e)}catch(t){a.error({message:"DynamicTabContextManager: Error saving dynamic tab context map",error:t})}}getPopupContext(t,r){try{if(!t||!r)return e.DEFAULT;const a=this.getDynamicTabContextMap()[t];if(!a)return e.DEFAULT;const n=a[r];return n?n.context:e.DEFAULT}catch(t){return a.error({message:"DynamicTabContextManager: Error getting popup context",error:t}),e.DEFAULT}}setPopupContext(t,e,r,n={}){try{if(!t||!e||!r)return;const a=this.getDynamicTabContextMap();a?.[t]||(a[t]={}),a[t][e]={context:r,lastUpdated:Date.now(),...n},this.saveDynamicTabContextMap(a)}catch(t){a.error({message:"DynamicTabContextManager: Error setting popup context",error:t})}}updateUrlData(t,e,r){try{const a=this.getDynamicTabContextMap();a[t]&&a[t][e]&&(a[t][e]={...a[t][e],...r,lastUpdated:Date.now()},this.saveDynamicTabContextMap(a))}catch(t){a.error({message:"DynamicTabContextManager: Error updating URL data",error:t})}}removeTabData(t){try{const a=this.getDynamicTabContextMap();a[t]&&(delete a[t],this.saveDynamicTabContextMap(a))}catch(t){a.error({message:"DynamicTabContextManager: Error removing tab data",error:t})}}getTabUrls(t){try{const a=this.getDynamicTabContextMap()[t];return a?Object.keys(a):[]}catch(t){return a.error({message:"DynamicTabContextManager: Error getting tab URLs",error:t}),[]}}getAllTabIds(){try{const t=this.getDynamicTabContextMap();return Object.keys(t).map((t=>parseInt(t)))}catch(t){return a.error({message:"DynamicTabContextManager: Error getting all tab IDs",error:t}),[]}}setupEventListeners(){chrome.tabs.onRemoved.addListener((t=>{this.removeTabData(t)})),chrome.tabs.onUpdated.addListener(((t,a,e)=>{"complete"===a.status&&a.url&&this.handleTabUpdate(t,e)}))}async handleTabUpdate(t,e){try{this.getDynamicTabContextMap()[t]&&e.url&&this.updateUrlData(t,e.url,{lastUpdated:Date.now()})}catch(t){a.error({message:"DynamicTabContextManager: Error handling tab update",error:t})}}clearAllData(){try{t.removeItem(this.storageKey)}catch(t){a.error({message:"DynamicTabContextManager: Error clearing all data",error:t})}}getTabData(t){try{return this.getDynamicTabContextMap()[t]||null}catch(t){return a.error({message:"DynamicTabContextManager: Error getting tab data",error:t}),null}}hasStoredContexts(t){try{const a=this.getTabData(t);return a&&Object.keys(a).length>0}catch(t){return!1}}hasStoredContextForUrl(t,a){try{const e=this.getTabData(t);return e&&e.hasOwnProperty(a)}catch(t){return!1}}};export default r;