/*
  ESP32S3 I2C Perepheral Demo
  esp32S3-perepheral.ino
  Demonstrates use of ESP32 as I2C perepheral
  Uses Seeeduino XIAO ESP32S3
  Reads value of potentiometer (0-255) on A0
  
  DroneBot Workshop 2025
  https://dronebotworkshop.com
*/

// Include Wire library for I2C
#include <Wire.h>

constexpr uint8_t I2C_ADDR = 0x2A;  // Peripheral address
constexpr int POT_PIN = 1;          // A0 on XIAO

volatile uint8_t potByte = 0;

// Read potentiometer and map to 0–255
uint8_t readPotByte() {
  analogReadResolution(12);  // 0..4095
  uint32_t acc = 0;
  for (int i = 0; i < 8; i++) {
    acc += analogRead(POT_PIN);
    delayMicroseconds(200);
  }
  uint16_t avg = acc / 8;
  return map(avg, 0, 4095, 0, 255);
}

// Called when Controller requests data
void onI2CRequest() {
  uint8_t value = potByte;
  Wire.write(&value, 1);
}

// Called when Controller sends data (not used here)
void onI2CReceive(int numBytes) {
  while (Wire.available()) (void)Wire.read();
}

void setup() {
  Serial.begin(115200);

  // Start in Peripheral (target) mode at I2C_ADDR
  // This uses the XIAO ESP32-S3 DEFAULT I2C pins (SDA=GPIO5, SCL=GPIO6)
  Wire.begin(I2C_ADDR);
  Wire.onRequest(onI2CRequest);
  Wire.onReceive(onI2CReceive);

  pinMode(POT_PIN, INPUT);

  Serial.printf("XIAO S3 Peripheral ready @ 0x%02X (default SDA/SCL)\n", I2C_ADDR);
}

void loop() {
  potByte = readPotByte();
  delay(5);  // light pacing
}
