/*
  ESP32 Wire I2C Scanner
  esp32-wirescan.ino
  Scans for I2C perepherals
  Change SDA and SCL pins to suit
    
  DroneBot Workshop 2025
  https://dronebotworkshop.com
*/
// Include Wire Library for I2C
#include <Wire.h>

// Define I2C pins (change as required)
constexpr int SDA_PIN = 4;
constexpr int SCL_PIN = 5;

void setup() {
  Serial.begin(115200);
  Wire.begin(SDA_PIN, SCL_PIN);
}
void loop() {
  Serial.println("Scan...");
  for (uint8_t a = 1; a < 127; a++) {
    Wire.beginTransmission(a);
    if (Wire.endTransmission() == 0) { Serial.printf("Found 0x%02X\n", a); }
  }
  delay(2000);
}
