/*
  ESP32 I2C Demo
  esp32-i2c-th-oled.ino
  Uses ESP32, OLED Display and Temperature/Humidity Sensor
  Demonstrates operation of I2C bus on ESP32
  
  DroneBot Workshop 2025
  https://dronebotworkshop.com
*/

#include <Wire.h>
#include <Adafruit_AHTX0.h>
#include <Adafruit_GFX.h>
#include <Adafruit_SSD1306.h>

// I2C pins for ESP32-C6
const int SDA_PIN = 4;
const int SCL_PIN = 5;

// OLED dimensions
#define SCREEN_WIDTH 128
#define SCREEN_HEIGHT 64

// Objects
Adafruit_AHTX0 aht;
Adafruit_SSD1306 display(SCREEN_WIDTH, SCREEN_HEIGHT, &Wire, -1);

void setup() {
  Serial.begin(115200);
  delay(200);

  Wire.begin(SDA_PIN, SCL_PIN);

  // Initialize OLED
  if (!display.begin(SSD1306_SWITCHCAPVCC, 0x3C)) {
    Serial.println("SSD1306 OLED not found");
    for (;;);
  }
  display.clearDisplay();

  // Initialize AHT20
  if (!aht.begin()) {
    Serial.println("AHT20 not found");
    display.setTextSize(1);
    display.setTextColor(SSD1306_WHITE);
    display.setCursor(0, 0);
    display.println("AHT20 not found");
    display.display();
    for (;;);
  }

  // Draw static title in yellow section
  display.setTextSize(1);
  display.setTextColor(SSD1306_WHITE);
  display.setCursor(10, 0); // Top yellow band
  display.println("Temp/Humid Demo");
  display.display();
  delay(1000);
}

void loop() {
  sensors_event_t humidity, temp;
  aht.getEvent(&humidity, &temp);

  // Debug to Serial
  Serial.print("Temp: ");
  Serial.print(temp.temperature, 1);
  Serial.print(" C  Humidity: ");
  Serial.print(humidity.relative_humidity, 1);
  Serial.println(" %");

  // Clear only the blue section (y = 16 to 63)
  display.fillRect(0, 16, SCREEN_WIDTH, SCREEN_HEIGHT - 16, SSD1306_BLACK);

  // Large temp in blue area
  display.setTextSize(2);
  display.setTextColor(SSD1306_WHITE);
  display.setCursor(0, 20); // Starting in blue section
  display.print(temp.temperature, 1);
  display.cp437(true);
  display.print(" C");

  // Large humidity in blue area
  display.setCursor(0, 45);
  display.print(humidity.relative_humidity, 1);
  display.print(" %RH");

  display.display();

  delay(2000);
}
