/*
  ESP32 I2C Controller Demo
  esp32-controller.ino
  Demonstrates use of ESP32 as I2C Controller
  Reads potentiometer values from perepheral
  
  DroneBot Workshop 2025
  https://dronebotworkshop.com
*/

#include <Wire.h>

constexpr uint8_t  I2C_ADDR  = 0x2A;
constexpr int      SDA_PIN   = 4;
constexpr int      SCL_PIN   = 5;

void setup() {
  Serial.begin(115200);
  delay(200);

  // Start I2C in Controller mode on pins 4/5
  Wire.begin(SDA_PIN, SCL_PIN);

  // Set a common clock; 100 kHz is fine, 400 kHz also works on short wires
  Wire.setClock(100000);

  Serial.println("I2C Controller ready. Querying 0x2A...");
}

void loop() {
  // Ask the peripheral for 1 byte (the pot position)
  uint8_t toRead = 1;
  uint8_t got = Wire.requestFrom((int)I2C_ADDR, (int)toRead);

  if (got == toRead && Wire.available()) {
    uint8_t pot = Wire.read();
    Serial.print("Pot value: ");
    Serial.println(pot);     // 0..255
  } else {
    Serial.println("Read failed (check wiring/address)");
  }

  delay(200); // Update ~5 times per second
}
