/*
  ESP32 Built-in Flash memory demo - Preferences
  esp32-preferences-demo.ino
  Demonstrates use of Preferences library with onboard Flash Memory
  Uses Seeeduino XIAO ESP32-S3
  
  DroneBot Workshop 2025
  https://dronebotworkshop.com
*/

// Include Preferences Library
#include <Preferences.h>
Preferences prefs;

// Define Potentiometer pin
const int POT_PIN = A0;

void setup() {
  // Start Serial Monitor
  Serial.begin(115200);

  // Start Preferences
  prefs.begin("nv-demo", false);

  // Persisted values
  uint32_t boots = prefs.getUInt("boots", 0);
  uint16_t lastPot = prefs.getUShort("lastPot", 0);

  // Increment boots value & store in memory
  boots++;
  prefs.putUInt("boots", boots);

  Serial.println("\n=== NVS (Preferences) Demo ===");
  Serial.printf("Boots so far: %lu\n", (unsigned long)boots);
  Serial.printf("Last saved pot: %u\n", lastPot);

  // Add delay for demo
  delay(2000);
}

void loop() {
  // Read potentiometer as a simple 0–4095 value
  uint16_t pot = analogRead(POT_PIN);

  // Reset  timer
  static uint32_t t0 = 0;

  // Update & save every 1.5 seconds
  if (millis() - t0 > 1500) {
    t0 = millis();
    prefs.putUShort("lastPot", pot);
    Serial.printf("Saved pot = %u\n", pot);
  }
}
