/*
  ESP32 Built-in Flash memory demo - LittleFS 1
  esp32-littlefs-save-demo.ino
  Demonstrates saving file in Built-in Flash Memory with LittleFS
  Seeeduino XIAO ESP32-S3 with Potentiometer on A0
  
  DroneBot Workshop 2025
  https://dronebotworkshop.com
*/

// Include Required Libraries
#include <FS.h>
#include <LittleFS.h>

// Potentiometer Pin
const int POT_PIN = A0;

// File name in LittleFS filespace
const char* LOG_PATH = "/potlog.txt";

// Append Line Function
void appendLine(const char* path, const String& line) {
  File f = LittleFS.open(path, LittleFS.exists(path) ? FILE_APPEND : FILE_WRITE);
  if (!f) {
    Serial.println("Append failed");
    return;
  }
  f.println(line);
  f.close();
}

void setup() {
  // Start Serial Monitor
  Serial.begin(115200);
  
  // Give the USB-CDC time to come up (helps on S2/S3 boards)
  uint32_t tStart = millis();
  while (!Serial && (millis() - tStart < 2000)) {}

  Serial.println("\n=== LittleFS WRITER (XIAO ESP32-S3) ===");
  
  // Mount filesystem if it exists
  if (!LittleFS.begin(true)) {  // true = format on first run if mount fails
    Serial.println("LittleFS mount failed");
    while (1) {}
  }

  // Set Potentiometer pin mode
  pinMode(POT_PIN, INPUT);

  // If file is new/empty, write a header row
  if (!LittleFS.exists(LOG_PATH) || LittleFS.open(LOG_PATH, FILE_READ).size() == 0) {
    appendLine(LOG_PATH, "ms,pot");
  }

  // get parameters
  size_t used = LittleFS.usedBytes();
  size_t total = LittleFS.totalBytes();
  Serial.printf("Mounted. Used %u / %u bytes\n", (unsigned)used, (unsigned)total);
  Serial.printf("Logging to %s every 1s. Open Serial Monitor to watch.\n", LOG_PATH);
}

void loop() {
  static uint32_t t0 = 0;
  
  // Get pot value every second
  if (millis() - t0 >= 1000) {
    t0 = millis();
    int pot = analogRead(POT_PIN);
    String line = String(millis()) + "," + String(pot);
    
    // Append to potlog.txt file
    appendLine(LOG_PATH, line);
    Serial.println("APPEND: " + line);
  }
}
