/*
  ESP32 Built-in Flash memory demo - LittleFS 2
  esp32-littlefs-read-demo.ino
  Demonstrates reading file stored in Built-in Flash Memory with LittleFS
  * Run after running esp32-littlefs-save-demo.ino
  Seeeduino XIAO ESP32-S3 with Potentiometer on A0
  
  DroneBot Workshop 2025
  https://dronebotworkshop.com
*/

// Include required libraries
#include <FS.h>
#include <LittleFS.h>

// Text file to read
const char* LOG_PATH = "/potlog.txt";

// Dump File Contents Function
void dumpFile(const char* path) {
  if (!LittleFS.exists(path)) {
    Serial.printf("File not found: %s\n", path);
    return;
  }
  File f = LittleFS.open(path, FILE_READ);
  if (!f) {
    Serial.println("Open failed");
    return;
  }

  Serial.printf("--- %s (size: %d bytes) ---\n", path, (int)f.size());
  // Stream out the whole file
  while (f.available()) {
    Serial.write(f.read());
  }
  Serial.println("\n------------------------------");
  f.close();
}

// List Root Directory Function
void listRoot() {
  File root = LittleFS.open("/");
  if (!root || !root.isDirectory()) {
    Serial.println("Root open failed");
    return;
  }
  Serial.println("Listing /");
  File file = root.openNextFile();
  if (!file) Serial.println("(empty)");
  while (file) {
    Serial.printf("  %s  (%d bytes)\n", file.name(), (int)file.size());
    file = root.openNextFile();
  }
}

void setup() {
  
  // Start Serial Monitor
  Serial.begin(115200);
  
  // Give the USB-CDC time to come up (helps on S2/S3 boards)
  uint32_t tStart = millis();
  while (!Serial && (millis() - tStart < 2000)) {}

  Serial.println("\n=== LittleFS READER (XIAO ESP32-S3) ===");

  // IMPORTANT: don't auto-format here—if mount fails, we want to know.
  if (!LittleFS.begin(false)) {  // false = do NOT format on failure
    Serial.println("LittleFS mount failed (did you run the Save Demo first?).");
    while (1) {}
  }

  // Get Parameters
  size_t used = LittleFS.usedBytes();
  size_t total = LittleFS.totalBytes();
  Serial.printf("Mounted. Used %u / %u bytes\n\n", (unsigned)used, (unsigned)total);

  // Show Directory
  listRoot();
  Serial.println();
  
  // Print file contents
  dumpFile(LOG_PATH);

  Serial.println("\nDone. Press EN/RESET to reprint.");
}

void loop() {
  // nothing—contents are printed once at boot
}
