/*
  ESP32 Built-in Flash memory demo - LittleFS 3
  esp32-littlefs-erase.ino
  Erases potlog.txt file used in demos 1 & 2
  
  DroneBot Workshop 2025
  https://dronebotworkshop.com
*/

// Include required libraries
#include <FS.h>
#include <LittleFS.h>

// Text file to erase
const char* LOG_PATH = "/potlog.txt";

void listRoot() {
  File root = LittleFS.open("/");
  if (!root || !root.isDirectory()) {
    Serial.println("Root open failed");
    return;
  }
  Serial.println("Listing /");
  File f = root.openNextFile();
  if (!f) Serial.println("(empty)");
  while (f) {
    Serial.printf("  %s  (%d bytes)\n", f.name(), (int)f.size());
    f = root.openNextFile();
  }
}

void setup() {
  Serial.begin(115200);
  uint32_t t0 = millis();
  while (!Serial && (millis() - t0 < 2000)) {}

  Serial.println("\n=== LittleFS DELETER (XIAO ESP32-S3) ===");

  // IMPORTANT: do not auto-format here; we want to see if the data partition exists.
  if (!LittleFS.begin(false)) {
    Serial.println("LittleFS mount failed. (Did you run the Writer first?)");
    while (1) {}
  }

  size_t used = LittleFS.usedBytes();
  size_t total = LittleFS.totalBytes();
  Serial.printf("Mounted. Used %u / %u bytes\n\n", (unsigned)used, (unsigned)total);

  Serial.println("Before deletion:");
  listRoot();
  Serial.println();

  if (LittleFS.exists(LOG_PATH)) {
    if (LittleFS.remove(LOG_PATH)) {
      Serial.printf("Deleted: %s\n", LOG_PATH);
    } else {
      Serial.printf("Delete FAILED: %s\n", LOG_PATH);
    }
  } else {
    Serial.printf("File not found (nothing to delete): %s\n", LOG_PATH);
  }

  Serial.println("\nAfter deletion:");
  listRoot();

  // ------ OPTIONAL: Full filesystem wipe (uncomment to use ONCE) ------
  // if (LittleFS.format()) Serial.println("\nFilesystem formatted (FULL WIPE).");
  // --------------------------------------------------------------------

  Serial.println("\nDone. Press EN/RESET to re-run.");
}

void loop() { /* nothing */
}
