/*
  ESP32 External SPI Flash Demo
  esp32-ext-flash-demo.ino
  Demonstrates use of W25Q64 Flash memory module
  Uses ESP32-S3 DevKit1
  Uses SPIMemory Library

  1 - Read Flash ID
  2 - Read Flash Capacity
  3 - Erase 4kB sector
  4 - Write and Read
  
  DroneBot Workshop 2025
  https://dronebotworkshop.com
*/

// Include Required Libraries
#include <SPI.h>
#include <SPIMemory.h>

// --- ESP32-S3 DevKitC-1 ---
static const int PIN_SCK = 12;   // CLK
static const int PIN_MISO = 13;  // DO  
static const int PIN_MOSI = 11;  // DI  
static const int PIN_CS = 10;    // CS

SPIFlash flash(PIN_CS);

void setup() {
  Serial.begin(115200);
  delay(200);
  Serial.println("\n=== W25Q64 Quick Test ===");

  SPI.begin(PIN_SCK, PIN_MISO, PIN_MOSI, PIN_CS);

  if (!flash.begin()) {
    Serial.println("Flash NOT detected. Check 3V3, GND, CS, and wiring.");
    while (1) delay(10);
  }

  // NEW: getJEDECID() returns a 32-bit value like 0xEF4017 for W25Q64
  uint32_t jedec = flash.getJEDECID();
  uint8_t manufacturer = (jedec >> 16) & 0xFF;
  uint8_t memType = (jedec >> 8) & 0xFF;
  uint8_t capacityCode = jedec & 0xFF;

  Serial.printf("JEDEC ID: 0x%06lX  (MFG=0x%02X TYPE=0x%02X CAP=0x%02X)\n",
                (unsigned long)jedec, manufacturer, memType, capacityCode);
  Serial.printf("Reported capacity: %lu bytes\n", (unsigned long)flash.getCapacity());

  const uint32_t addr = 0x00000;  // sector 0
  Serial.println("Erasing 4KB sector @ 0x000000...");
  if (!flash.eraseSector(addr)) Serial.println("Erase FAILED");

  // NEW: make it non-const for writeCharArray (or use writeAnything)
  char msg[] = "Hello from ESP32-S3 + W25Q64!";
  bool okW = flash.writeCharArray(addr, msg, sizeof(msg));  // includes '\0'
  char buf[sizeof(msg)] = { 0 };
  bool okR = flash.readCharArray(addr, buf, sizeof(buf));

  Serial.printf("Write: %s  Read: %s\n", okW ? "OK" : "FAIL", okR ? "OK" : "FAIL");
  Serial.print("Data: ");
  Serial.println(buf);
}

void loop() {}
