/*****************************************************************************
*
* This file is part of Calíope.
* Copyright (c) 2008-2026 David Villalobos Cambronero (david.villalobos.c@gmail.com).
*
* Calíope is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* Calíope is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
*
*****************************************************************************/

#ifndef SVNLOG_H
#define SVNLOG_H

class QFileInfo;
class DTitleLabel;

#include "dmdisubwindow.h"

/**
 * @brief The SVNLog class displays the revision history of a file.
 *
 * This class inherits from DMdiSubWindow and provides a viewer for the
 * Subversion (SVN) log messages associated with a specific file. It typically
 * runs the `svn log` command in the background and presents the output
 * (revision number, author, date, and commit message) to the user.
 */
class SVNLog : public DMdiSubWindow
{
  Q_OBJECT

public:
  /**
   * @brief Constructs the SVNLog window.
   * @param file The path to the file whose history will be displayed.
   */
  SVNLog(QString file);

  /**
   * @brief Retranslates the user interface.
   *
   * Updates window titles and labels to reflect the current application language.
   */
  void retranslateUI();

private:
  QFileInfo *svnFile;
  DTitleLabel *dTitleLabel;
};

#endif // SVNLOG_H
