/*****************************************************************************
*
* This file is part of Calíope.
* Copyright (c) 2008-2026 David Villalobos Cambronero (david.villalobos.c@gmail.com).
*
* Calíope is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* Calíope is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
*
*****************************************************************************/

#include <QVBoxLayout>
#include <QCheckBox>
#include <QGroupBox>
#include <QFormLayout>
#include <QFileInfo>
#include <QListWidget>
#include <QListWidgetItem>
#include <QDialogButtonBox>
#include <QMessageBox>
#include <QProgressDialog>
#include <QPlainTextEdit>
#include <QApplication>

#include <iostream>
#include <fstream>
using namespace std;

#include "basetexteditor.h"
#include "restorebackupfile.h"
#include "dtitlelabel.h"
#include "staticfunctions.h"
#include "dfileselector.h"
#include "dicon.h"

#include <QDebug>

RestoreBackupFile::RestoreBackupFile(DBMS *serverConnection)
{
  this->serverConnection = serverConnection;
  setWindowIcon(DIcon::DatabaseRestore());

  QVBoxLayout *mainVLayout = new QVBoxLayout;
  mainVLayout->setContentsMargins(3, 0, 3, 0);
  dTitleLabel = new DTitleLabel;
  mainVLayout->addWidget(dTitleLabel);
  dFileSelector = new DFileSelector(DFileSelectorContexts::BackupFile);
  dFileSelector->setFileName(settings.value("RestoreBackup/LastRestoredFile", "").toString());

  fileGroupBox = new QGroupBox;
  fileGroupBoxLayout = new QFormLayout;
  fileLabel = new QLabel;
  fileLabel->setTextFormat(Qt::PlainText);
  dataLengthLabel = new QLabel;
  fileGroupBoxLayout->addRow(" ", fileLabel);
  fileGroupBoxLayout->addRow(" ", dataLengthLabel);
  force = new QCheckBox("--force");
  optionsGroupBox = new QGroupBox;
  baseTextEditor = new BaseTextEditor(EditorTypes::NoEditor);
  baseTextEditor->setWordWrapMode(QTextOption::WordWrap);
  baseTextEditor->showHideLineNumbers(false);
  QHBoxLayout *fileLayout = new QHBoxLayout;
  connect(dFileSelector, SIGNAL(changed()), this, SLOT(getFileInfo()));
  fileLayout->addWidget(dFileSelector);
  mainVLayout->addLayout(fileLayout);

  fileGroupBox->setLayout(fileGroupBoxLayout);
  mainVLayout->addWidget(fileGroupBox);

  optionsGroupBoxLayout = new QGridLayout;
  force->setStatusTip(force->toolTip());
  force->setWhatsThis(force->toolTip());
  force->setAttribute(Qt::WA_AlwaysShowToolTips, true);
  optionsGroupBoxLayout->addWidget(force, 0, 0, Qt::AlignLeft);

  optionsGroupBox->setLayout(optionsGroupBoxLayout);
  mainVLayout->addWidget(optionsGroupBox);
  mainVLayout->addWidget(baseTextEditor);

  buttonBox = new QDialogButtonBox(QDialogButtonBox::Ok | QDialogButtonBox::Help);
  connect(buttonBox, SIGNAL(accepted()), this, SLOT(buttonBoxAcceptSlot()));
  mainVLayout->addWidget(buttonBox);

  retranslateUI();
  getFileInfo();

  QWidget *widMain = new QWidget;
  widMain->setLayout(mainVLayout);
  setWidget(widMain);
}

void RestoreBackupFile::retranslateUI()
{
  setWindowTitle(tr("Restore Backup File"));
  setObjectName(windowTitle());
  dTitleLabel->setText(windowTitle());
  dTitleLabel->setToolTip(dTitleLabel->text());
  dFileSelector->setText(tr("&File:"));
  fileGroupBox->setTitle(tr("File information"));
  QLabel *label = qobject_cast<QLabel *>(fileGroupBoxLayout->labelForField(fileLabel));
  label->setText(tr("File:"));
  label->setToolTip(label->text());
  force->setToolTip(tr("Continue even if an SQL error occurs during a table dump."));
  force->setStatusTip(force->toolTip());
  label = qobject_cast<QLabel *>(fileGroupBoxLayout->labelForField(dataLengthLabel));
  label->setText(tr("Total data length:"));
  label->setToolTip(label->text());
  optionsGroupBox->setTitle(tr("Options"));
  optionsGroupBox->setToolTip(optionsGroupBox->title());
}

void RestoreBackupFile::getFileInfo(QString file)
{
  if (file.isEmpty())
    file = dFileSelector->getFileName();
  QFileInfo fileInfo(file);
  fileLabel->setText(dFileSelector->getFileName());
  fileLabel->setToolTip(fileLabel->text());
  dataLengthLabel->setText("~" + StaticFunctions::bytesConvertor(QString("%1").arg(fileInfo.size())));
  dataLengthLabel->setToolTip(dataLengthLabel->text());
  settings.setValue("RestoreBackup/LastRestoredFile", file);
}

void RestoreBackupFile::buttonBoxAcceptSlot()
{
  if (dFileSelector->getFileName().isEmpty()) {
    QMessageBox::information(this, tr("Backup file missing"), tr("Please select a backup file."));
    return;
  }
  QApplication::setOverrideCursor(Qt::WaitCursor);

  QString line;
  QString statement;
  bool multilineStatement = false;
  bool restoreConnectionOpened;
  baseTextEditor->clear();
  cancelRestore = false;
  insertingData = false;
  restoreProgressDialog = new QProgressDialog(tr("Restore backup"), tr("Abort"), 0, 0, this);
  connect(restoreProgressDialog, SIGNAL(canceled()), this, SLOT(cancelRestoreProgressDialogSlot()));
  restoreProgressDialog->setWindowModality(Qt::WindowModal);
  restoreProgressDialog->setAutoClose(true);
  restoreProgressDialog->show();

  restoreConnection = mysql_init(NULL);
  if (!restoreConnection)
    QMessageBox::warning(0, tr("Library initialization"), tr("Error on library initialization for the database restore connection."));

  if (this->serverConnection->getUseSSL())
    mysql_ssl_set(restoreConnection, this->serverConnection->getKeyFile().toUtf8().data()
                  , this->serverConnection->getCertFile().toUtf8().data(), NULL, NULL, NULL);
  restoreConnectionOpened = mysql_real_connect(restoreConnection, this->serverConnection->getHostName().toUtf8().data()
                                               , this->serverConnection->getUserName().toUtf8().data()
                                               , this->serverConnection->getPassword().toUtf8().data()
                                               , this->serverConnection->getDatabase().isEmpty() ? NULL : this->serverConnection->getDatabase().toUtf8().data()
                                                                                                   , this->serverConnection->getPort()
                                               , NULL, 0);
//  dMariaDBRealQueryOnQThread = new DMariaDBRealQueryOnQThread(restoreConnection);
  if (restoreConnectionOpened) {
    string myText;
    ifstream file(dFileSelector->getFileName().toUtf8());

    while (getline (file, myText)) {
      if (cancelRestore && !force->isChecked())
        break;
      if (myText.substr(0, 7) == "INSERT ") {
//        if (threadCounter == 100)
          executeStatement(myText);
//        if (threadCounter == 100)
//          continue;
      }
      if ((myText.substr(0, 3) != "-- ") && !myText.empty()) {
        line = QString::fromStdString(myText);
//        qDebug() << line;
        if (line.startsWith("DELIMITER // -- Start")) {
          multilineStatement = true;
          statement = "";
          continue; //To avoid the concatenation of the word DELIMITER
        }
        if (line.startsWith("DELIMITER // -- End")) {
          multilineStatement = false;
//          if (threadCounter == 100)
            executeStatement(statement.toStdString());
        }
        if (multilineStatement) {
          statement += (line + "\n");
        }
      }
    }
    file.close();
    mysql_close(restoreConnection);
  }

//  if (inputFile.open(QIODevice::ReadOnly)) {
//    QTextStream in(&inputFile);
//    while (!in.atEnd()) {
//      if (cancelRestore && !force->isChecked())
//        break;
//      line = in.readLine();
//      if (line.startsWith("INSERT ")) {
//        executeStatement(line);
//        continue;
//      }
//      if (!line.startsWith("-- ") && !line.isEmpty()) {
//        if (line.startsWith("DELIMITER // -- Start")) {
//          multilineStatement = true;
//          statement = "";
//          continue; //To avoid the concatenation of the word DELIMITER
//        }
//        if (line.startsWith("DELIMITER // -- End")) {
//          multilineStatement = false;
//          executeStatement(statement);
//        }
//        if (multilineStatement) {
//          statement += (line + "\n");
//        }
//      }
//    }
//    inputFile.close();

//  QFile inputFile(dFileSelector->getFileName());
//  QString line;
//  QString statement;
//  bool multilineStatement = false;
//  baseTextEditor->clear();
//  cancelRestore = false;
//  insertingData = false;
//  restoreProgressDialog = new QProgressDialog(tr("Restore backup"), tr("Abort"), 0, 0, this);
//  connect(restoreProgressDialog, SIGNAL(canceled()), this, SLOT(cancelRestoreProgressDialogSlot()));
//  restoreProgressDialog->setWindowModality(Qt::WindowModal);
//  restoreProgressDialog->setAutoClose(true);
//  restoreProgressDialog->show();
//  if (inputFile.open(QIODevice::ReadOnly)) {
//    QTextStream in(&inputFile);
//    while (!in.atEnd()) {
//      if (cancelRestore && !force->isChecked())
//        break;
//      line = in.readLine();
//      if (line.startsWith("INSERT ")) {
//        executeStatement(line);
//        continue;
//      }
//      if (!line.startsWith("-- ") && !line.isEmpty()) {
//        if (line.startsWith("DELIMITER // -- Start")) {
//          multilineStatement = true;
//          statement = "";
//          continue; //To avoid the concatenation of the word DELIMITER
//        }
//        if (line.startsWith("DELIMITER // -- End")) {
//          multilineStatement = false;
//          executeStatement(statement);
//        }
//        if (multilineStatement) {
//          statement += (line + "\n");
//        }
//      }
//    }
//    inputFile.close();
//  }
//  //  emit loadProgress(100);
  QApplication::restoreOverrideCursor();
  QString message(!cancelRestore ? tr("Restore done") : tr("Restore canceled"));
  restoreProgressDialog->close();
  QMessageBox::information(this, message, message);
}

void RestoreBackupFile::cancelRestoreProgressDialogSlot()
{
  cancelRestore = true;
}

void RestoreBackupFile::executeStatement(std::string statement)
{
//  threadCounter++;
//  qDebug() << threadCounter;
//  dMariaDBRealQueryOnQThread->setStatement(statement);
////  if (threadCounter > 100) {

////  }
//  dMariaDBRealQueryOnQThread->start();

//////  cout << statement;
//  qDebug() << statement;
  if (mysql_real_query(restoreConnection, statement.c_str(), statement.size()) != 0) {
    qDebug() << QString("%1 %2 %3").arg(tr("Error: ")).arg(mysql_errno(restoreConnection)).arg(mysql_error(restoreConnection));
             // << statement;
  }
//  threadCounter--;

  if (statement.substr(0, 7) == "INSERT ") {
    insertingData = true;
    baseTextEditor->insertPlainText(tr("Inserting data...") + "\n");
  } else {
    insertingData = false;
  }
  if (!insertingData)
    baseTextEditor->insertPlainText(tr("Working on:") + " " + QString::fromStdString(statement).split("\n").at(0).mid(0, 120) + "\n");
  baseTextEditor->gotoLine(baseTextEditor->document()->blockCount(), false);

//  if (statement.startsWith("INSERT ")) {
//    insertingData = true;
//    baseTextEditor->insertPlainText(tr("Inserting data...") + "\n");
//  } else {
//    insertingData = false;
//  }
//  if (!insertingData)
//    baseTextEditor->insertPlainText(tr("Working on:") + " " + statement.split("\n").at(0).mid(0, 120) + "\n");
//  baseTextEditor->gotoLine(baseTextEditor->document()->blockCount(), false);
//  serverConnection->runQuery(statement);
}
