/*****************************************************************************
*
* This file is part of Calíope.
* Copyright (c) 2008-2026 David Villalobos Cambronero (david.villalobos.c@gmail.com).
*
* Calíope is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* Calíope is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
*
*****************************************************************************/

#ifndef OBJECTSDIAGRAM_H
#define OBJECTSDIAGRAM_H

#include <QGraphicsItem>

class QGraphicsView;
class QGraphicsScene;
class DTitleLabel;

#include "dmdisubwindow.h"

/**
 * @brief A custom graphics item representing a database table.
 *
 * This class inherits from QGraphicsItem and defines how a table entity
 * is visualized (painted) and interacts within the objects diagram scene.
 */
class TableGraphicsItem : public QGraphicsItem
{
public:
  /**
   * @brief Constructs a TableGraphicsItem.
   */
  TableGraphicsItem();

  /**
   * @brief Defines the outer bounds of the item.
   *
   * Reimplemented from QGraphicsItem. Used for collision detection and repainting.
   * @return A QRectF representing the bounding rectangle of the table item.
   */
  QRectF boundingRect() const;

  /**
   * @brief Paints the visual representation of the table.
   *
   * Reimplemented from QGraphicsItem. Draws the box, title, and other visual elements.
   *
   * @param painter The painter used to draw the item.
   * @param option Provides style options for the item.
   * @param widget The widget that is being painted on (optional).
   */
  void paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget);
};

/**
 * @brief The ObjectsDiagram class displays a visual representation of database objects.
 *
 * This class inherits from DMdiSubWindow and utilizes the Qt Graphics View Framework
 * (QGraphicsScene and QGraphicsView) to render an Entity-Relationship (ER) diagram
 * or schema visualization containing tables and their relationships.
 */
class ObjectsDiagram : public DMdiSubWindow
{
  Q_OBJECT

public:
  /**
   * @brief Constructs the ObjectsDiagram window.
   *
   * Initializes the graphics scene and view.
   */
  ObjectsDiagram();

  /**
   * @brief Retranslates the user interface.
   *
   * Updates window titles and labels to reflect the current application language.
   */
  void retranslateUI();

private:
  QGraphicsView *view;
  QGraphicsScene *scene;
  DTitleLabel *dTitleLabel;
};

#endif // OBJECTSDIAGRAM_H
