/*****************************************************************************
*
* This file is part of Calíope.
* Copyright (c) 2008-2026 David Villalobos Cambronero (david.villalobos.c@gmail.com).
*
* Calíope is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* Calíope is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
*
*****************************************************************************/

#ifndef OBJECTMIGRATION_H
#define OBJECTMIGRATION_H

class QTreeWidget;
class BaseTextEditor;
class QTreeWidgetItem;
class QCheckBox;
class QRadioButton;
class DTitleLabel;
class QGroupBox;
class QPushButton;

#include "dbms.h"
#include "dmdisubwindow.h"

/**
 * @brief The ObjectMigration class facilitates the migration of database objects.
 *
 * This class inherits from DMdiSubWindow and provides a GUI to select databases,
 * tables, or other objects to move between a primary and a secondary database connection.
 * It supports generating SQL for schema creation and data insertion.
 */
class ObjectMigration : public DMdiSubWindow
{
  Q_OBJECT

public:
  /**
   * @brief Constructs the ObjectMigration window.
   * @param serverConnection Pointer to the primary (source) DBMS connection.
   */
  ObjectMigration(DBMS *serverConnection);

  /**
   * @brief Retranslates the user interface.
   *
   * Updates labels, buttons, and options to reflect the current application language.
   */
  void retranslateUI();

private:
  DBMS *serverConnection;
  DBMS *secondaryServerConnection;
  DTitleLabel *dTitleLabel;
  QTreeWidget *objectsListWidget;
  BaseTextEditor *resultEditor;
  QPushButton *migratePushButton;
  QList<QTreeWidgetItem *> databases;
  QCheckBox *optionDROP;
  QGroupBox *groupBoxAction;
  QCheckBox *optionExportData;
  QStringList statementsToExecute;
  int counter;
  QCheckBox *optionFOREIGN_KEY_CHECKS;
  QCheckBox *optionPreview;
  QPushButton *stopMigrationPushButton;

private slots:
  /**
   * @brief Populates the tree widget with the list of available databases and objects.
   */
  void fillDatabasesSlot();

  /**
   * @brief Handles item activation (e.g., clicks) in the object tree.
   * @param item The tree item that was activated.
   * @param column The column index.
   */
  void itemActivatedSlot(QTreeWidgetItem *item, int column);

  /**
   * @brief Initiates the migration process based on selected options.
   *
   * Generates the necessary SQL statements and prepares them for execution.
   */
  void migratePushButtonSlot();

  /**
   * @brief Iteratively executes the generated migration statements.
   */
  void statementsToExecuteSlot();

  /**
   * @brief Stops the ongoing migration process.
   */
  void stopMigrationPushButtonSlot();

signals:
  /**
   * @brief Emitted to update the progress of the migration operation.
   * @param progress The completion percentage (0-100).
   */
  void loadProgress(const int progress);
};

#endif // OBJECTMIGRATION_H
