/*****************************************************************************
*
* This file is part of Calíope.
* Copyright (c) 2008-2026 David Villalobos Cambronero (david.villalobos.c@gmail.com).
*
* Calíope is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* Calíope is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
*
*****************************************************************************/

#ifndef NEWDATABASE_H
#define NEWDATABASE_H

#include <QDialog>

#include "dbms.h"

class QLineEdit;
class QComboBox;

/**
 * @brief The NewDatabase class provides a dialog for creating a new database schema.
 *
 * This class inherits from QDialog and allows the user to specify the name
 * and character set (charset/collation) for a new database. It uses the provided
 * DBMS connection to execute the resulting CREATE DATABASE statement.
 */
class NewDatabase : public QDialog
{
  Q_OBJECT

public:
  /**
   * @brief Constructs the NewDatabase dialog.
   * @param serverConnection Pointer to the active DBMS connection.
   */
  NewDatabase(DBMS *serverConnection);

private:
  DBMS *serverConnection;
  QLineEdit *lineEditName;
  QComboBox *comboCharacterset;

private slots:
  /**
   * @brief Generates and executes the SQL statement to create the database.
   *
   * This slot is triggered when the user accepts the dialog (e.g., clicks "OK" or "Create").
   * It retrieves the name and character set from the UI elements and sends the command
   * to the database server.
   */
  void applyStatement();
};

#endif // NEWDATABASE_H
