/*****************************************************************************
*
* This file is part of Calíope.
* Copyright (c) 2008-2026 David Villalobos Cambronero (david.villalobos.c@gmail.com).
*
* Calíope is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* Calíope is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
*
*****************************************************************************/

#ifndef MARIADBHELP_H
#define MARIADBHELP_H

#include <QTreeWidget>

#include "dmdisubwindow.h"
#include "dbms.h"
#include "dsettings.h"

class QTextEdit;
class QLineEdit;
class QSplitter;
class DLineEdit;
class DTitleLabel;

/**
 * @brief The MariaDBHelp class displays server-side help documentation.
 *
 * This class inherits from DMdiSubWindow and provides an interface to browse
 * the standard MariaDB/MySQL help topics (typically stored in the 'mysql' database).
 * It includes a searchable tree view for topics and a text area to display the
 * detailed help content.
 */
class MariaDBHelp : public DMdiSubWindow
{
  Q_OBJECT

public:
  /**
   * @brief Constructs the MariaDBHelp window.
   * @param serverConnection Pointer to the active DBMS connection used to query help tables.
   */
  MariaDBHelp(DBMS *serverConnection);

  /**
   * @brief Retranslates the user interface.
   *
   * Updates window titles and tooltips to reflect the current application language.
   */
  void retranslateUI();

private:
  DSettings settings;
  QTextEdit *helpView;
  DBMS *serverConnection;
  DLineEdit *lineEditFilter;
  QTreeWidget *helpTreeWidget;
  QList<QStringList> *rows;
  QSplitter *mainSplitter;
  DTitleLabel *dTitleLabel;

private slots:
  /**
   * @brief Displays the content of the selected help topic.
   * @param item The tree item that was clicked.
   * @param column The column index (usually 0).
   */
  void showTopicSlot(QTreeWidgetItem *item, int column);

  /**
   * @brief Saves the current splitter position to settings.
   * @param pos The new position of the splitter handle.
   * @param index The index of the splitter handle.
   */
  void saveSizesSlot(int pos, int index);

  /**
   * @brief Populates or filters the help topic tree.
   *
   * Queries the database for help topics. If a filter is provided, only matching
   * topics are displayed.
   *
   * @param filter The search string to filter topics.
   */
  void fillHelpTreeWidget(QString filter = QString());
};

#endif // MARIADBHELP_H
