/*****************************************************************************
*
* This file is part of Calíope.
* Copyright (c) 2008-2026 David Villalobos Cambronero (david.villalobos.c@gmail.com).
*
* Calíope is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* Calíope is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
*
*****************************************************************************/

#include <QVBoxLayout>
#include <QLabel>
#include <QSplitter>
#include <QTreeWidget>
#include <QLineEdit>
#include <QTextEdit>
#include <QSettings>

#include "mariadbhelp.h"
#include "dtitlelabel.h"
#include "staticfunctions.h"
#include "dlineedit.h"
#include "dicon.h"

#include "QFile"

MariaDBHelp::MariaDBHelp(DBMS *serverConnection)
{
  this->serverConnection = serverConnection;
  setWindowIcon(DIcon::Database());

    QVBoxLayout *mainVLayout = new QVBoxLayout;
  //  mainVLayout->setContentsMargins(3, 0, 3, 0);
  //  dTitleLabel = new DTitleLabel;
  //  mainVLayout->addWidget(dTitleLabel);

  //  helpTreeWidget = new QTreeWidget;
  //  helpTreeWidget->setColumnCount(1);
  //  connect(helpTreeWidget, SIGNAL(itemActivated(QTreeWidgetItem*,int)), this, SLOT(showTopicSlot(QTreeWidgetItem*,int)));
  //  connect(helpTreeWidget, SIGNAL(itemClicked(QTreeWidgetItem*,int)), this, SLOT(showTopicSlot(QTreeWidgetItem*,int)));

  //  fillHelpTreeWidget();

  //  lineEditFilter = new DLineEdit(DIcon::ViewFilter());
  //  connect(lineEditFilter, SIGNAL(textChangedSignal(QString)), this, SLOT(fillHelpTreeWidget(QString)));
  //  connect(lineEditFilter, SIGNAL(returnKeyPressed(QString)), this, SLOT(fillHelpTreeWidget(QString)));

  //  QVBoxLayout *treeHelpLayout = new QVBoxLayout;
  //  treeHelpLayout->addWidget(lineEditFilter);
  //  treeHelpLayout->addWidget(helpTreeWidget);
  //  treeHelpLayout->setContentsMargins(0, 0, 0, 0);
  //  QWidget *widTreeHelp = new QWidget;
  //  widTreeHelp->setLayout(treeHelpLayout);
  //  widTreeHelp->setMaximumWidth(250);

  //  helpView = new QTextEdit;
  //  helpView->setFont(StaticFunctions::fixedWidthFont());

  //  mainSplitter = new QSplitter(Qt::Horizontal);
  //  mainSplitter->addWidget(widTreeHelp);
  //  mainSplitter->addWidget(helpView);

  //  connect(mainSplitter, SIGNAL(splitterMoved(int,int)), this, SLOT(saveSizesSlot(int,int)));

//  mainVLayout->addWidget(mainSplitter);

    QFile fileToOpen("MaiaDB-Help.html");
    bool opened = fileToOpen.open(QFile::ReadOnly | QFile::Text);
    Q_UNUSED(opened);
    QTextEdit *textEdit = new QTextEdit;
    textEdit->setHtml(QString::fromUtf8(fileToOpen.readAll()));
  mainVLayout->addWidget(textEdit);
  QWidget *widMain = new QWidget;
  widMain->setLayout(mainVLayout);
//  retranslateUI();
  setWidget(widMain);
}

void MariaDBHelp::retranslateUI()
{
  setWindowTitle(tr("MariaDB Help"));
  setObjectName(windowTitle());
  dTitleLabel->setText(windowTitle());
  dTitleLabel->setToolTip(dTitleLabel->text());
  helpTreeWidget->setHeaderLabel(tr("Topics"));
  lineEditFilter->setPlaceholderText(tr("Enter a Keyword"));
}

void MariaDBHelp::fillHelpTreeWidget(QString filter)
{
  helpTreeWidget->clear();
  QList<QTreeWidgetItem *> items;
  QTreeWidgetItem *item = new QTreeWidgetItem();
  QTreeWidgetItem *itemChild;
  QStringList rows2;
  QString currentParent = "";

  rows = serverConnection->runQuery(
  "SELECT `a`.`name` AS `HelpCategory`, `b`.`name` AS `HelpTopic`"
  "FROM `mysql`.`help_category` `a`"
  "  JOIN `mysql`.`help_topic` `b` ON (`a`.`help_category_id` = `b`.`help_category_id`)"
  + (filter.isEmpty() ? "" : ("WHERE `b`.`name` LIKE '%" + filter + "%'"))
  + " UNION "
  "SELECT `c`.`name` AS `HelpKeyWord`, `b`.`name` AS `HelpTopic`"
  "FROM `mysql`.`help_keyword` `c`"
  "  JOIN `mysql`.`help_relation` `d` ON (`c`.`help_keyword_id` = `d`.`help_keyword_id`)"
  "  JOIN `mysql`.`help_topic` `b` ON (`d`.`help_topic_id` = `b`.`help_topic_id`)"
  + (filter.isEmpty() ? "" : ("WHERE `c`.`name` LIKE '%" + filter + "%'"))
  + "ORDER BY `HelpCategory`, `HelpTopic`"
  );
  rows->takeLast(); //Remove the "Affected rows" line.

  for (int counter = 0; counter < rows->count(); counter++) {
    if (currentParent != rows->at(counter).at(0)) {
      currentParent = rows->at(counter).at(0);
      item = new QTreeWidgetItem((QTreeWidget*)0, QStringList(rows->at(counter).at(0)));
      item->setIcon(0, DIcon::Database());
      itemChild = new QTreeWidgetItem(item, QStringList(rows->at(counter).at(1)));
      itemChild->setIcon(0, DIcon::Database());
      items.append(item);
    } else {
      itemChild = new QTreeWidgetItem(item, QStringList(rows->at(counter).at(1)));
      itemChild->setIcon(0, DIcon::Database());
    }
  }
  helpTreeWidget->insertTopLevelItems(0, items);
}

void MariaDBHelp::showTopicSlot(QTreeWidgetItem *item, int column)
{
  rows = serverConnection->runQuery("SELECT `description`, `example`, `url` FROM `mysql`.`help_topic` WHERE `name` = '" + item->text(column) + "'");
  rows->takeLast(); //Remove the "Affected rows" line.
  if (rows->count() > 0)
    helpView->setHtml("<H1>" + tr("Syntax:") + "</H1>" + QString(rows->at(0).at(0)).replace("\n", "<BR />")
                      + "<H1>" + tr("Example:") + "</H1>"
                      + rows->at(0).at(1)
                      + "<H1>" + tr("URL:") + "</H1>"
                      + "<A href='" + rows->at(0).at(2) + "'>" + rows->at(0).at(2) + "</A>");
}

void MariaDBHelp::saveSizesSlot(int pos, int index)
{
  Q_UNUSED(index);
  settings.setValue("MySQLHelp/Sizes", QString("%1").arg(pos));
}
