/*****************************************************************************
*
* This file is part of Calíope.
* Copyright (c) 2008-2026 David Villalobos Cambronero (david.villalobos.c@gmail.com).
*
* Calíope is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* Calíope is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
*
*****************************************************************************/

#include <QApplication>
#include <QFile>
#include <QString>
#include <QDateTime>

#include "mainwindow.h"

void myMessageOutput(QtMsgType type, const QMessageLogContext &context, const QString &msg)
{
//  QByteArray localMsg = msg.toLocal8Bit();
  QFile logFile(qApp->property("ErrorLogFile").toString());
  QString messageType;
  bool opened = logFile.open(QFile::Append | QFile::Text);
  Q_UNUSED(opened);
  switch (type) {
  case QtDebugMsg:
//    fprintf(stderr, "Debug: %s, File: %s, Line:%u, Function: %s. Category: %s, Version: %u.\n", localMsg.constData(), context.file, context.line, context.function, context.category, context.version);
    messageType = "Debug";
    break;
  case QtWarningMsg:
//    fprintf(stderr, "Warning: %s, File: %s, Line:%u, Function: %s. Category: %s, Version: %u.\n", localMsg.constData(), context.file, context.line, context.function, context.category, context.version);
    messageType = "Warning";
    break;
  case QtCriticalMsg:
//    fprintf(stderr, "Critical: %s, File: %s, Line:%u, Function: %s. Category: %s, Version: %u.\n", localMsg.constData(), context.file, context.line, context.function, context.category, context.version);
    messageType = "Critical";
    break;
  case QtFatalMsg:
//    fprintf(stderr, "Fatal: %s, File: %s, Line:%u, Function: %s. Category: %s, Version: %u.\n", localMsg.constData(), context.file, context.line, context.function, context.category, context.version);
    messageType = "Fatal";
    break;
  case QtInfoMsg:
//    fprintf(stderr, "Informatition: %s, File: %s, Line:%u, Function: %s. Category: %s, Version: %u.\n", localMsg.constData(), context.file, context.line, context.function, context.category, context.version);
    messageType = "Informatition";
    break;
  }
  QString message = QString("%1 | %2 | File: %3 | Line: %4 | Function: %5 | Category: %6 | Version: %7 | %8 \n")
                      .arg(QDateTime::currentDateTime().toString("yyyy-MM-dd-HH-mm-ss")
                           , messageType
                           , QString(context.file)
                           , QString::number(context.line)
                           , QString(context.function)
                           , QString(context.category)
                           , QString::number(context.version)
                           , msg.toLocal8Bit());
  fprintf(stderr, "%s", message.toLocal8Bit().constData());
  logFile.write(message.toLocal8Bit());
  logFile.close();
  if (type == QtFatalMsg)
    abort();
}

int main(int argc, char *argv[])
{
  Q_INIT_RESOURCE(images);
  Q_INIT_RESOURCE(translations);
  Q_INIT_RESOURCE(styles);
  Q_INIT_RESOURCE(documentation);
  Q_INIT_RESOURCE(libraries);
  Q_INIT_RESOURCE(qml);
  qInstallMessageHandler(myMessageOutput);
  ///QCoreApplication::setAttribute(Qt::AA_EnableHighDpiScaling);
  int currentExitCode = 0;
  do {
    QApplication app(argc, argv);
    MainWindow *mainWindow = new MainWindow;
    mainWindow->show();
    currentExitCode = app.exec();
  } while (currentExitCode == MainWindow::EXIT_CODE_REBOOT);
  return currentExitCode;
}
