/*****************************************************************************
*
* This file is part of Calíope.
* Copyright (c) 2008-2026 David Villalobos Cambronero (david.villalobos.c@gmail.com).
*
* Calíope is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* Calíope is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
*
*****************************************************************************/

#include <QTextDocumentFragment>
#include <QPainterPath>

#include "framingtexthandler.h"

#include <QDebug>

FramingTextHandler::FramingTextHandler()
{
}

QSizeF FramingTextHandler::intrinsicSize(QTextDocument *doc, int posInDocument, const QTextFormat &format)
{
  Q_UNUSED(doc)
  Q_UNUSED(posInDocument)
//  Q_UNUSED(format)
  const QTextCharFormat &charFormat = reinterpret_cast<const QTextCharFormat&>(format);
  QFont font = charFormat.font();
  QFontMetrics fontMetrics(font);
  return fontMetrics.boundingRect(format.property(UserDefinedCharFormatPropertyId).toString() + placeHolderText).size();
}

void FramingTextHandler::drawObject(QPainter *painter, const QRectF &rect, QTextDocument *doc, int posInDocument, const QTextFormat &format)
{
  Q_UNUSED(doc)
  Q_UNUSED(posInDocument)
//  Q_UNUSED(format)

//  qDebug() << format.property(UserDefinedCharFormatPropertyId).toString();
//  painter->drawRoundedRect(rect, 4, 4);


  painter->setRenderHint(QPainter::Antialiasing);
  QPainterPath path;
  path.addRoundedRect(rect, 4, 4);
  QPen pen(Qt::black, 2);
  painter->setPen(pen);
  painter->fillPath(path, QColor(255, 250, 205));
  painter->drawPath(path);
  painter->drawText(rect, format.property(UserDefinedCharFormatPropertyId).toString() + placeHolderText);
}

//Q_DECLARE_METATYPE(QTextDocumentFragment)
