/*****************************************************************************
*
* This file is part of Calíope.
* Copyright (c) 2008-2026 David Villalobos Cambronero (david.villalobos.c@gmail.com).
*
* Calíope is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* Calíope is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
*
*****************************************************************************/

#include <QTextDocumentFragment>

#include "foldingtexthandler.h"

FoldingTextHandler::FoldingTextHandler()
{
}

QSizeF FoldingTextHandler::intrinsicSize(QTextDocument *doc, int posInDocument, const QTextFormat &format)
{
  Q_UNUSED(doc)
  Q_UNUSED(posInDocument)
  const QTextCharFormat &charFormat = reinterpret_cast<const QTextCharFormat&>(format);
  QFont font = charFormat.font();
  QFontMetrics fontMetrics(font);
//  QString placeHolder("...");
//  QSizeF placeHolderSize = fontMetrics.boundingRect(placeHolder).size();
//  return placeHolderSize;
  return fontMetrics.boundingRect("...").size();
}

void FoldingTextHandler::drawObject(QPainter *painter, const QRectF &rect, QTextDocument *doc, int posInDocument, const QTextFormat &format)
{
  Q_UNUSED(doc)
  Q_UNUSED(posInDocument)
  Q_UNUSED(format)
  painter->drawText(rect, "...");
  painter->drawRect(rect);
}

//Q_DECLARE_METATYPE(QTextDocumentFragment)
