/*****************************************************************************
*
* This file is part of Calíope.
* Copyright (c) 2008-2026 David Villalobos Cambronero (david.villalobos.c@gmail.com).
*
* Calíope is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* Calíope is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
*
*****************************************************************************/

#ifndef FILEASSOCIATIONS_H
#define FILEASSOCIATIONS_H

#include <QWidget>

#include "dsettings.h"

class QLineEdit;
class QFormLayout;

/**
 * @brief The FileAssociations class manages the configuration of file type associations.
 *
 * This widget allows the user to define or modify how the application interacts
 * with specific file extensions (e.g., .sql) within the operating system or environment.
 */
class FileAssociations : public QWidget
{
  Q_OBJECT

public:
  /**
   * @brief Constructs the FileAssociations widget.
   */
  FileAssociations();

  /**
   * @brief Retranslates the user interface.
   *
   * Updates labels and text to match the current application language.
   */
  void retranslateUI();

  /**
   * @brief Retrieves the current list of file associations.
   *
   * @return A QString containing the configured associations (formatted as a list or string).
   */
  QString FileAssociationsList();

private:
  QLineEdit *sqlLineEdit;
  DSettings settings;

  /**
   * @brief Internal helper to format or sanitize association text.
   * @param text The raw input text.
   * @return The transformed text string.
   */
  QString textTransformation(QString text);

  QFormLayout *formLayout;

private slots:
  /**
   * @brief Handles changes to the SQL file association input.
   * @param newText The new text entered by the user.
   */
  void sqlLineEditTextChangedSlot(QString newText);

};

#endif // FILEASSOCIATIONS_H
