/*****************************************************************************
*
* This file is part of Calíope.
* Copyright (c) 2008-2026 David Villalobos Cambronero (david.villalobos.c@gmail.com).
*
* Calíope is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* Calíope is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
*
*****************************************************************************/

#ifndef EDITORTYPES_H
#define EDITORTYPES_H

/**
 * @brief Container class for editor mode definitions.
 *
 * This class serves as a namespace for the EditorType enumeration, which is used
 * throughout the application to determine the behavior and context of the main
 * document area (e.g., whether it is editing SQL, viewing a diff, or showing logs).
 */
class EditorTypes
{
public:
  /**
   * @brief Enumeration representing the specific type of the active editor or view.
   */
  enum EditorType {
    SQLQuery,   /**< Standard SQL text editor mode. */
    Diff,       /**< File comparison (diff) viewer mode. */
    Commit,     /**< Version control commit interface mode. */
    NoEditor,   /**< No active editor or empty state. */
    SVNLog      /**< Subversion (SVN) log viewer mode. */
  };
};

#endif // EDITORTYPES_H
