/*****************************************************************************
*
* This file is part of Calíope.
* Copyright (c) 2008-2026 David Villalobos Cambronero (david.villalobos.c@gmail.com).
*
* Calíope is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* Calíope is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
*
*****************************************************************************/

#include <QPainter>
#include <QMoveEvent>
#include <QStyle>

#include "dtour.h"

#include <QDebug>

DTour::DTour(QWidget *parent, QMap<QString, uint> sizes)/* : QWidget(parent)*/
{
  this->parent = parent;
  this->sizes = sizes;
  step = 1;
  windowsValor = 0;
  setAttribute(Qt::WA_TranslucentBackground);
  setFocusPolicy(Qt::StrongFocus);
  setWindowFlag(Qt::Tool, true);
#if defined(Q_OS_WIN)
  windowsValor = this->parent->style()->pixelMetric(QStyle::PM_TitleBarHeight);
  setWindowFlag(Qt::FramelessWindowHint, true);
  setGeometry(this->parent->geometry().adjusted(0, 0, 0, windowsValor));
#elif defined(Q_OS_LINUX)
  setGeometry(this->parent->geometry());
#elif defined(Q_OS_MAC)
  setGeometry(this->parent->geometry());
#endif
  setFocus();
  parent->installEventFilter(this);
  grayBrush.setColor(QColor(145, 145, 145, 128));
  grayBrush.setStyle(Qt::SolidPattern);
  highlightedBrush.setColor(QColor(73, 212, 214, 128));
  highlightedBrush.setStyle(Qt::SolidPattern);
//  qDebug() << this->parent->style()->pixelMetric(QStyle::PM_TitleBarHeight);
  moveWindow();
}

void DTour::moveWindow()
{
  move(this->parent->pos());
}

void DTour::drawStep1()
{
  QPainter painter(this);
//  QPen pen(Qt::red, 5, Qt::DashDotLine, Qt::RoundCap, Qt::RoundJoin);
//  painter.setPen(pen);

#if defined(Q_OS_WIN)
  //Paint the top "gray" area
  polygon.clear();
  polygon << QPoint(0, 0)
          << QPoint(0, windowsValor)
          << QPoint(width(), windowsValor)
          << QPoint(width(), 0)
             ;
  painterPath.clear();
  painterPath.addPolygon(polygon);
  painter.drawPolygon(polygon);
  painter.fillPath(painterPath, grayBrush);
#endif

  //Paint the "highlighted" area
  polygon.clear();
  polygon << QPoint(0, 0 + windowsValor)
          << QPoint(0, this->sizes.value("MainMenuHeight") + windowsValor)
          << QPoint(width(), this->sizes.value("MainMenuHeight") + windowsValor)
          << QPoint(width(), 0 + windowsValor)
             ;
  painterPath.clear();
  painterPath.addPolygon(polygon);
  painter.drawPolygon(polygon);
  painter.fillPath(painterPath, highlightedBrush);

  //Paint the "gray" area
  polygon.clear();
  polygon << QPoint(0, this->sizes.value("MainMenuHeight") + windowsValor)
          << QPoint(0, height())
          << QPoint(width(), height())
          << QPoint(width(), this->sizes.value("MainMenuHeight") + windowsValor)
             ;
  painterPath.clear();
  painterPath.addPolygon(polygon);
  painter.drawPolygon(polygon);
  painter.fillPath(painterPath, grayBrush);

  //Paint the text
  font = painter.font();
  font.setPixelSize(16);
  font.setBold(true);
  painter.setFont(font);
  painter.drawText(QPoint(width() / 2, 15 + windowsValor), tr("Main menu"));
}

void DTour::drawStep2()
{
  QPainter painter(this);
//  QPen pen(Qt::red, 5, Qt::DashDotLine, Qt::RoundCap, Qt::RoundJoin);
//  painter.setPen(pen);

  //Paint the top "gray" area
  polygon.clear();
  polygon << QPoint(0, 0)
          << QPoint(0, this->sizes.value("MainMenuHeight") + windowsValor)
          << QPoint(width(), this->sizes.value("MainMenuHeight") + windowsValor)
          << QPoint(width(), 0)
             ;
  painterPath.clear();
  painterPath.addPolygon(polygon);
  painter.drawPolygon(polygon);
  painter.fillPath(painterPath, grayBrush);

  //Paint the "highlighted" area
  polygon.clear();
  polygon << QPoint(0, this->sizes.value("MainMenuHeight") + windowsValor)
          << QPoint(0, this->sizes.value("MainToolbarHeight") + windowsValor)
          << QPoint(width(), this->sizes.value("MainToolbarHeight") + windowsValor)
          << QPoint(width(), this->sizes.value("MainMenuHeight") + windowsValor)
             ;
  painterPath.clear();
  painterPath.addPolygon(polygon);
  painter.drawPolygon(polygon);
  painter.fillPath(painterPath, highlightedBrush);

  //Paint the bottom "gray" area
  polygon.clear();
  polygon << QPoint(0, this->sizes.value("MainToolbarHeight") + windowsValor)
          << QPoint(0, height())
          << QPoint(width(), height())
          << QPoint(width(), this->sizes.value("MainToolbarHeight") + windowsValor)
             ;
  painterPath.clear();
  painterPath.addPolygon(polygon);
  painter.drawPolygon(polygon);
  painter.fillPath(painterPath, grayBrush);

  //Paint the text
  font = painter.font();
  font.setPixelSize(16);
  font.setBold(true);
  painter.setFont(font);
  painter.drawText(QPoint(width() / 2, this->sizes.value("MainMenuHeight") + 15 + windowsValor), tr("Quick action menu"));
}

void DTour::drawStep3()
{
  QPainter painter(this);
//  QPen pen(Qt::red, 5, Qt::DashDotLine, Qt::RoundCap, Qt::RoundJoin);
//  painter.setPen(pen);

  //Paint the top "gray" area
  polygon.clear();
  polygon << QPoint(0, 0)
          << QPoint(0, this->sizes.value("MainToolbarHeight") + windowsValor)
          << QPoint(width(), this->sizes.value("MainToolbarHeight") + windowsValor)
          << QPoint(width(), 0)
             ;
  painterPath.clear();
  painterPath.addPolygon(polygon);
  painter.drawPolygon(polygon);
  painter.fillPath(painterPath, grayBrush);

  //Paint the "highlighted" area
  polygon.clear();
  polygon << QPoint(0, this->sizes.value("MainToolbarHeight") + windowsValor)
          << QPoint(0, height() - this->sizes.value("StatusbarHeight"))
          << QPoint(width(), height() - this->sizes.value("StatusbarHeight"))
          << QPoint(width(), this->sizes.value("MainToolbarHeight") + windowsValor)
             ;
  painterPath.clear();
  painterPath.addPolygon(polygon);
  painter.drawPolygon(polygon);
  painter.fillPath(painterPath, highlightedBrush);

  //Paint the bottom "gray" area
  polygon.clear();
  polygon << QPoint(0, height() - this->sizes.value("StatusbarHeight"))
          << QPoint(0, height())
          << QPoint(width(), height())
          << QPoint(width(), height() - this->sizes.value("StatusbarHeight"))
             ;
  painterPath.clear();
  painterPath.addPolygon(polygon);
  painter.drawPolygon(polygon);
  painter.fillPath(painterPath, grayBrush);

  //Paint the text
  font = painter.font();
  font.setPixelSize(16);
  font.setBold(true);
  painter.setFont(font);
  painter.drawText(QPoint(width() / 4, this->sizes.value("MainMenuHeight") + this->sizes.value("MainToolbarHeight") + windowsValor), tr("Working area"));
}

void DTour::drawStep4()
{
  QPainter painter(this);
//  QPen pen(Qt::red, 5, Qt::DashDotLine, Qt::RoundCap, Qt::RoundJoin);
//  painter.setPen(pen);

  //Paint the top "gray" area
  polygon.clear();
  polygon << QPoint(0, 0)
          << QPoint(0, height() - this->sizes.value("StatusbarHeight"))
          << QPoint(width(), height() - this->sizes.value("StatusbarHeight"))
          << QPoint(width(), 0)
             ;
  painterPath.clear();
  painterPath.addPolygon(polygon);
  painter.drawPolygon(polygon);
  painter.fillPath(painterPath, grayBrush);

  //Paint the "highlighted" area
  polygon.clear();
  polygon << QPoint(0, height() - this->sizes.value("StatusbarHeight"))
          << QPoint(0, height())
          << QPoint(width(), height())
          << QPoint(width(), height() - this->sizes.value("StatusbarHeight"))
             ;
  painterPath.clear();
  painterPath.addPolygon(polygon);
  painter.drawPolygon(polygon);
  painter.fillPath(painterPath, highlightedBrush);

  //Paint the text
  font = painter.font();
  font.setPixelSize(16);
  font.setBold(true);
  painter.setFont(font);
  painter.drawText(QPoint(width() / 2, height() - 10), tr("Status bar"));
}

void DTour::drawLastStep()
{
  hide();
}

void DTour::paintEvent(QPaintEvent *event)
{
  QWidget::paintEvent(event);
  switch (step) {
  case 1:
    drawStep1();
    break;
  case 2:
    drawStep2();
    break;
  case 3:
    drawStep3();
    break;
  case 4:
    drawStep4();
    break;
  default:
    drawLastStep();
    break;
  }
}

void DTour::mousePressEvent(QMouseEvent *event)
{
  QWidget::mousePressEvent(event);
  step++;
  repaint();
}

void DTour::moveEvent(QMoveEvent *event)
{
  QWidget::moveEvent(event);
  this->parent->move(this->pos());
}
