/*****************************************************************************
*
* This file is part of Calíope.
* Copyright (c) 2008-2026 David Villalobos Cambronero (david.villalobos.c@gmail.com).
*
* Calíope is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* Calíope is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
*
*****************************************************************************/

#ifndef DTITLELABEL_H
#define DTITLELABEL_H

#include <QLabel>

/**
 * @brief The DTitleLabel class is a customized QLabel for displaying titles.
 *
 * This widget is intended to be used as a header or section title within
 * the application, likely applying specific font styling or formatting
 * distinct from standard text labels.
 */
class DTitleLabel : public QLabel
{
  Q_OBJECT

public:
  /**
   * @brief Constructs the DTitleLabel.
   * @param text The initial title text to display (optional).
   */
  DTitleLabel(const QString text = QString());

  /**
   * @brief Updates the text of the title label.
   * @param text The new string to display.
   */
  void setTitleText(const QString text);
};

#endif // DTITLELABEL_H
