/*****************************************************************************
*
* This file is part of Calíope.
* Copyright (c) 2008-2026 David Villalobos Cambronero (david.villalobos.c@gmail.com).
*
* Calíope is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* Calíope is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
*
*****************************************************************************/

#ifndef DSTATUSBAR_H
#define DSTATUSBAR_H

#include <QStatusBar>

class QProgressBar;
class QLabel;

/**
 * @brief The DStatusBar class is a customized status bar widget.
 *
 * This class extends QStatusBar to include integrated widgets for operations
 * frequently used in this application, such as a progress bar and coordinate/position
 * labels (X, Y, Z).
 */
class DStatusBar : public QStatusBar
{
  Q_OBJECT

public:
  /**
   * @brief Constructs the DStatusBar.
   *
   * Initializes the progress bar and position labels within the status bar.
   */
  DStatusBar();

  /**
   * @brief Displays a temporary popup message on the status bar.
   * @param message The text to display.
   * @param timeout The duration in milliseconds to show the message (0 = indefinite).
   */
  void showMessagePopup(const QString &message, int timeout = 0);

  /**
   * @brief Resets the status bar to its default state.
   *
   * Clears current messages and hides/resets the progress bar.
   */
  void resetStatusBar();

  /**
   * @brief Displays a message with special formatting or styling.
   * @param text The text to display.
   * @param timeout The duration in milliseconds to show the message.
   */
  void showFancyMessage(const QString &text, int timeout = 0);

public slots:
  /**
   * @brief Updates the position viewer labels (e.g., cursor coordinates).
   * @param x The X coordinate (or Column).
   * @param y The Y coordinate (or Row).
   * @param z The Z coordinate (or Selection length).
   */
  void setPositionViewer(const int x, const int y, const int z);

  /**
   * @brief Updates the value of the embedded progress bar.
   * @param progress The percentage of completion (0-100).
   */
  void setProgress(const int progress = 0);

private:
  QProgressBar *progressBar;
  QLabel *labelPosition;

protected:
  /**
   * @brief Handles mouse double-click events on the status bar.
   *
   * Reimplemented from QWidget to detect interactions with the status bar area.
   * @param event The mouse event parameters.
   */
  void mouseDoubleClickEvent(QMouseEvent *event);
};

#endif // DSTATUSBAR_H
