/*****************************************************************************
*
* This file is part of Calíope.
* Copyright (c) 2008-2026 David Villalobos Cambronero (david.villalobos.c@gmail.com).
*
* Calíope is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* Calíope is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
*
*****************************************************************************/

#ifndef DSTARTUPTIPS_H
#define DSTARTUPTIPS_H

#include <QDialog>
#include <QTextTableCell>

#include "dsettings.h"

class QDialogButtonBox;
class QAbstractButton;
class QCheckBox;
class QTextEdit;

/**
 * @brief The DStartupTips class displays a "Tip of the Day" dialog.
 *
 * This dialog provides users with helpful usage hints, keyboard shortcuts,
 * or features they might not know about. It includes navigation to view
 * previous or next tips and a checkbox to disable the automatic popup on startup.
 */
class DStartupTips : public QDialog
{
  Q_OBJECT

public:
  /**
   * @brief Constructs the DStartupTips dialog.
   *
   * Initializes the tip list and sets up the user interface.
   */
  DStartupTips();

private:
  DSettings settings;
  QDialogButtonBox *buttonBox;
  QCheckBox *showStartupTips;
  QTextEdit *documentTips;

  /**
   * @brief Loads and displays the tip at the specified index.
   * @param position The index of the tip in the list (defaults to 0).
   */
  void tips(int position = 0);

  QList<QStringList> tipsToUse;
  int tipPossition;
  QStringList tip;

private slots:
  /**
   * @brief Handles clicks on the dialog buttons (e.g., Next, Previous, Close).
   * @param button The button that was clicked.
   */
  void actionRoleSlot(QAbstractButton *button);

  /**
   * @brief Saves the "Show tips on startup" preference when the checkbox is toggled.
   */
  void showStartupTipsStateChanged();

};

#endif // DSTARTUPTIPS_H
