/*****************************************************************************
*
* This file is part of Calíope.
* Copyright (c) 2008-2026 David Villalobos Cambronero (david.villalobos.c@gmail.com).
*
* Calíope is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* Calíope is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
*
*****************************************************************************/

#include <QVBoxLayout>
#include <QDialogButtonBox>
#include <QCheckBox>
#include <QTextEdit>
#include <QRandomGenerator>

#include "dstartuptips.h"
#include "dicon.h"
#include "dtitlelabel.h"

#include "QDebug"

DStartupTips::DStartupTips()
{
  setWindowTitle(tr("Startup Tips"));
  setObjectName(windowTitle());
  setWindowIcon(DIcon::Caliope());
  setMinimumSize(550, 450);

  buttonBox = new QDialogButtonBox(QDialogButtonBox::Close);
  buttonBox->addButton(tr("Previous"), QDialogButtonBox::ActionRole);
  buttonBox->addButton(tr("Next"), QDialogButtonBox::ActionRole);
  connect(buttonBox, SIGNAL(accepted()), this, SLOT(accept()));
  connect(buttonBox, SIGNAL(rejected()), this, SLOT(reject()));
  connect(buttonBox, SIGNAL(clicked(QAbstractButton*)), this, SLOT(actionRoleSlot(QAbstractButton*)));

  showStartupTips = new QCheckBox();
  showStartupTips->setText(tr("Show Startup Tips"));
  showStartupTips->setToolTip(showStartupTips->text());
  showStartupTips->setStatusTip(showStartupTips->toolTip());
  showStartupTips->setWhatsThis(showStartupTips->toolTip());
  showStartupTips->setAttribute(Qt::WA_AlwaysShowToolTips, true);
  showStartupTips->setChecked(settings.value("GeneralSettings/ShowStartupTips", true).toBool());
  connect(showStartupTips, SIGNAL(stateChanged(int)), this, SLOT(showStartupTipsStateChanged()));

  tipsToUse.append(QStringList() << "1" << tr("Wellcome!!! Have a nice day.") << DIcon::StartupTip1());
  tipsToUse.append(QStringList() << "2" << tr("Tip 2") << DIcon::StartupTip1());
  tipsToUse.append(QStringList() << "3" << tr("Tip 3") << DIcon::StartupTip1());

  documentTips = new QTextEdit();
  tips();

  QVBoxLayout *verticalLayout = new QVBoxLayout;
  verticalLayout->addWidget(new DTitleLabel(windowTitle()));
  verticalLayout->addWidget(documentTips);
  verticalLayout->addWidget(showStartupTips);
  verticalLayout->addWidget(buttonBox);
  setLayout(verticalLayout);
}

void DStartupTips::actionRoleSlot(QAbstractButton *button)
{
  if (button->text() == tr("Previous")) {
    tips(-1);
  } else if (button->text() == tr("Next")) {
    tips(1);
  }
}

void DStartupTips::tips(int position)
{
  documentTips->clear();
  QRandomGenerator random;
  QTextCursor cursor(documentTips->textCursor());
  cursor.movePosition(QTextCursor::Start);
  QTextTable *table = cursor.insertTable(1, 2);
  switch (position) {
  case 0:
    random = QRandomGenerator(QTime::currentTime().second());
    tipPossition = (int) random.bounded(32767) % tipsToUse.size();
    break;
  case 1:
    (tipPossition + 1) > tipsToUse.size() ? tipPossition : tipPossition++;
    break;
  case -1:
    (tipPossition - 1) <= 0 ? 0 : tipPossition--;
    break;
  default:
  break;
  }
  table->cellAt(0, 0).firstCursorPosition().insertText(tipsToUse[tipPossition == 0 ? 0 : tipPossition - 1].at(1));
  table->cellAt(0, 1).firstCursorPosition().insertImage(tipsToUse[tipPossition == 0 ? 0 : tipPossition - 1].at(2));
}

void DStartupTips::showStartupTipsStateChanged()
{
  settings.setValue("GeneralSettings/ShowStartupTips", showStartupTips->isChecked());
}
