/*****************************************************************************
*
* This file is part of Calíope.
* Copyright (c) 2008-2026 David Villalobos Cambronero (david.villalobos.c@gmail.com).
*
* Calíope is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* Calíope is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
*
*****************************************************************************/

#ifndef DSTACKEDWIDGET_H
#define DSTACKEDWIDGET_H

#include <QWidget>

class QStackedWidget;
class QListWidget;

/**
 * @brief The DStackedWidget class combines a navigation list with a page stack.
 *
 * This composite widget features a side list (QListWidget) used to navigate
 * between different pages stored in a QStackedWidget. This pattern is commonly
 * used in settings or preferences dialogs.
 */
class DStackedWidget : public QWidget
{
  Q_OBJECT

public:
  /**
   * @brief Constructs the DStackedWidget.
   *
   * Initializes the layout, the list widget for navigation, and the stacked
   * widget for content display.
   */
  explicit DStackedWidget();

  /**
   * @brief Adds a new page to the widget.
   *
   * Creates a corresponding item in the navigation list with the specified
   * icon and label, and adds the content widget to the stack.
   *
   * @param widget The content widget to be displayed on this page.
   * @param icon The icon to be displayed in the navigation list.
   * @param label The text label to be displayed in the navigation list.
   * @return The index of the added widget in the stack.
   */
  int addWidget(QWidget *widget, const QIcon & icon, const QString & label);

private:
  QStackedWidget *stackedWidget;
  QListWidget *listWidget;
};

#endif // DSTACKEDWIDGET_H
