/*****************************************************************************
*
* This file is part of Calíope.
* Copyright (c) 2008-2026 David Villalobos Cambronero (david.villalobos.c@gmail.com).
*
* Calíope is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* Calíope is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
*
*****************************************************************************/

#include <QCoreApplication>

#include "dsettings.h"

#include <QDebug>

DSettings::DSettings()
{
//  QSettings settings(QSettings::IniFormat, QSettings::UserScope, QCoreApplication::organizationName(), QCoreApplication::applicationName());
}

void DSettings::setValue(QAnyStringView key, const QVariant &value)
{
  QSettings settings(QSettings::IniFormat, QSettings::UserScope, QCoreApplication::organizationName(), QCoreApplication::applicationName());
  return settings.setValue(key, value);
}

QVariant DSettings::value(QAnyStringView key, const QVariant &defaultValue) const
{
  QSettings settings(QSettings::IniFormat, QSettings::UserScope, QCoreApplication::organizationName(), QCoreApplication::applicationName());
  return settings.value(key, defaultValue);
}

QVariant DSettings::value(QAnyStringView key) const
{
  QSettings settings(QSettings::IniFormat, QSettings::UserScope, QCoreApplication::organizationName(), QCoreApplication::applicationName());
  return settings.value(key);
}

QString DSettings::fileName() const
{
  QSettings settings(QSettings::IniFormat, QSettings::UserScope, QCoreApplication::organizationName(), QCoreApplication::applicationName());
  return settings.fileName();
}

//void DSettings::beginGroup(QAnyStringView prefix)
//{
//  QSettings settings(QSettings::IniFormat, QSettings::UserScope, QCoreApplication::organizationName(), QCoreApplication::applicationName());
//  settings.beginGroup(prefix);
//}

//void DSettings::endGroup()
//{
//  QSettings settings(QSettings::IniFormat, QSettings::UserScope, QCoreApplication::organizationName(), QCoreApplication::applicationName());
//  settings.endGroup();
//}

//QString DSettings::group() const
//{
//  QSettings settings(QSettings::IniFormat, QSettings::UserScope, QCoreApplication::organizationName(), QCoreApplication::applicationName());
//  return settings.group();
//}

QStringList DSettings::allKeys(QAnyStringView groupName)
{
  QSettings settings(QSettings::IniFormat, QSettings::UserScope, QCoreApplication::organizationName(), QCoreApplication::applicationName());
  QStringList keys;
  settings.beginGroup(groupName);
  keys = settings.allKeys();
  settings.endGroup();
  return keys;
}

void DSettings::clearGroup(QAnyStringView groupName)
{
  QSettings settings(QSettings::IniFormat, QSettings::UserScope, QCoreApplication::organizationName(), QCoreApplication::applicationName());
  settings.beginGroup(groupName);
  settings.group().clear();
  settings.endGroup();
}

void DSettings::remove(QAnyStringView key)
{
  QSettings settings(QSettings::IniFormat, QSettings::UserScope, QCoreApplication::organizationName(), QCoreApplication::applicationName());
  settings.remove(key);
}

void DSettings::sync()
{
  QSettings settings(QSettings::IniFormat, QSettings::UserScope, QCoreApplication::organizationName(), QCoreApplication::applicationName());
  settings.sync();
}
