/*****************************************************************************
*
* This file is part of Calíope.
* Copyright (c) 2008-2026 David Villalobos Cambronero (david.villalobos.c@gmail.com).
*
* Calíope is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* Calíope is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
*
*****************************************************************************/

#ifndef DQUERYLOG_H
#define DQUERYLOG_H

#include "dmdisubwindow.h"
#include "dbms.h"

class DTitleLabel;
class QTableView;
class QGroupBox;
class QPushButton;
class QComboBox;
class QLabel;
class DLineEdit;

/**
 * @brief The DQueryLog class provides a user interface for viewing the SQL execution history.
 *
 * This window displays a log of queries executed by the application (typically stored
 * locally, e.g., in an SQLite file). It provides functionality to filter specific queries,
 * view file statistics, and clear the history.
 */
class DQueryLog : public DMdiSubWindow
{
  Q_OBJECT

public:
  /**
   * @brief Constructs the DQueryLog window.
   * @param serverConnection Pointer to the current DBMS connection context.
   */
  DQueryLog(DBMS *serverConnection);

private:
  DTitleLabel *dTitleLabel;
  DBMS *serverConnection;
  QTableView *queryLogTableView;
  QGroupBox *buttonBox;
  QPushButton *pushButtonRefresh;
  QComboBox *comboBoxFilter;
  QPushButton *pushButtonClearQueryLog;
  QLabel *labelFileSize;

  /**
   * @brief Retrieves and displays information about the log storage file.
   *
   * Updates the UI with details such as the current file size of the query log.
   */
  void getFileInfo();

  DLineEdit *lineEditFilter;
  QLabel *filterByQuery;

private slots:
  /**
   * @brief Refreshes the table view with the latest log entries.
   */
  void pushButtonRefreshClicked();

  /**
   * @brief Handles changes in the combo box filter selection.
   * @param filter The selected filter criteria text.
   */
  void comboBoxFilterActivated(QString filter);

  /**
   * @brief Clears the query history log.
   *
   * Triggers the deletion of log entries from the storage file.
   */
  void pushButtonClearQueryLogClicked();

  /**
   * @brief Filters the log table based on text input.
   * @param filter The text string to search for within the query history.
   */
  void lineEditFilterTextChangedSlot(QString filter);

  /**
   * @brief Retranslates the user interface.
   *
   * Updates labels, buttons, and titles to reflect the current application language.
   */
  void retranslateUI();

};

#endif // DQUERYLOG_H
