/*****************************************************************************
*
* This file is part of Calíope.
* Copyright (c) 2008-2026 David Villalobos Cambronero (david.villalobos.c@gmail.com).
*
* Calíope is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* Calíope is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
*
*****************************************************************************/

#ifndef DPIECHARTWIDGET_H
#define DPIECHARTWIDGET_H

#include <QWidget>

/**
 * @brief The DPieChartWidget class provides a lightweight custom pie chart implementation.
 *
 * Unlike the QtCharts based widgets, this class inherits directly from QWidget
 * and implements custom painting logic via paintEvent to render a simple pie chart
 * based on key-value pairs.
 */
class DPieChartWidget : public QWidget
{
  Q_OBJECT

public:
  /**
   * @brief Constructs the pie chart widget.
   * @param unit The unit string to display alongside values (e.g., "MB", "%").
   */
  DPieChartWidget(QString unit = QString());

  /**
   * @brief Adds a new data slice to the chart.
   * @param key The label or name of the slice.
   * @param value The numerical value representing the size of the slice.
   */
  void addEntry(const QString key, const double value);

  /**
   * @brief Removes all data entries from the chart.
   */
  void clear();

  /**
   * @brief Sets the unit of measurement text.
   * @param unit The string representing the unit.
   */
  void setUnit(QString unit);

  /**
   * @brief Retrieves the current unit of measurement.
   * @return A QString containing the unit.
   */
  QString getUnit();

  /**
   * @brief Triggers a visual update of the widget.
   *
   * Forces the widget to be repainted to reflect changes in data.
   */
  void repaintWidget();

protected:
  /**
   * @brief Handles the painting event to draw the chart.
   *
   * Overrides QWidget::paintEvent to perform the actual drawing of
   * arcs and legends.
   *
   * @param event The paint event parameters.
   */
  void paintEvent(QPaintEvent *event);

private:
  //QHash<QString, int> values;
  QList<QPair<QString, double> > values;
  QString unit;
};

#endif // DPIECHARTWIDGET_H
