/*****************************************************************************
*
* This file is part of Calíope.
* Copyright (c) 2008-2026 David Villalobos Cambronero (david.villalobos.c@gmail.com).
*
* Calíope is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* Calíope is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
*
*****************************************************************************/

#include <QPainter>

#include "dpiechartwidget.h"
#include "staticfunctions.h"

DPieChartWidget::DPieChartWidget(QString unit)
{
  this->unit = unit;
}

void DPieChartWidget::addEntry(const QString key, const double value)
{
  values.append(qMakePair(key, value));
}

void DPieChartWidget::clear()
{
  values.clear();
}

void DPieChartWidget::setUnit(QString unit)
{
  this->unit = unit;
}

QString DPieChartWidget::getUnit()
{
  return unit;
}

void DPieChartWidget::repaintWidget()
{
  paintEvent(0);
}

void DPieChartWidget::paintEvent(QPaintEvent *event)
{
  Q_UNUSED(event);
  QPainter painter(this);
  painter.setRenderHint(QPainter::Antialiasing, true);

  double totalValues = 0;
  for (int counter = 0; counter < values.count(); counter++)
    totalValues += values.at(counter).second;

  QStringList colorNames = QColor::colorNames();
  int colorPos = 13;
  QRect pieRect(10, 10, rect().height() - 10, rect().height() - 20);

  QRect legendRect = rect();
  legendRect.setLeft(pieRect.width());
  legendRect.adjust(20, 20, -10, -10);
  int lastAngleOffset = 0;
  int currentPos = 0;

  for (int counter = 0; counter < values.count(); counter++) {
    painter.setBrush(QBrush(QColor(colorNames.at(colorPos++ % colorNames.count()))));

    int angle = (int) (16 * 360 * (values.at(counter).second / totalValues));

    painter.drawPie(pieRect, lastAngleOffset, angle);
    lastAngleOffset += angle;

    QRect legendEntryRect(0,(fontMetrics().height() * 2) * currentPos, fontMetrics().height(), fontMetrics().height());
    currentPos++;
    legendEntryRect.translate(legendRect.topLeft());

    painter.drawRect(legendEntryRect);

    QPoint textStart = legendEntryRect.topRight();
    textStart = textStart + QPoint(fontMetrics().horizontalAdvance('X'), 0);

    QPoint textEnd(legendRect.right(), legendEntryRect.bottom());
    QRect textEntryRect(textStart, textEnd);
    painter.drawText(textEntryRect, Qt::AlignVCenter, QString("%1: %2. %3%.")
                     .arg(values.at(counter).first
                     , StaticFunctions::currentLocale().toString(values.at(counter).second, 'f', 2)
                     , QString::number((values.at(counter).second * 100 / totalValues), 'f', 2)
                     ));
  }
  QRect legendEntryRect(0,(fontMetrics().height() * 2) * currentPos, fontMetrics().height(), fontMetrics().height());
  currentPos++;
  legendEntryRect.translate(legendRect.topLeft());
  QPoint textStart = legendEntryRect.topRight();
  textStart = textStart + QPoint(fontMetrics().horizontalAdvance('X'), 0);
  QPoint textEnd(legendRect.right(), legendEntryRect.bottom());
  QRect textEntryRect(textStart, textEnd);
  painter.drawText(textEntryRect, Qt::AlignVCenter, tr("Total: %1 %2.").arg(StaticFunctions::currentLocale().toString(totalValues, 'f', 2), unit));
}
