/*****************************************************************************
*
* This file is part of Calíope.
* Copyright (c) 2008-2026 David Villalobos Cambronero (david.villalobos.c@gmail.com).
*
* Calíope is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* Calíope is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
*
*****************************************************************************/

#ifndef DMESSAGELABEL_H
#define DMESSAGELABEL_H

#include <QWidget>

class QLabel;

/**
 * @brief Container class for message severity types.
 */
class MessageTypes
{
public:
  /**
   * @brief Enumeration representing the severity or category of a message.
   *
   * Used to determine the icon and visual style of the message label.
   */
  enum MessageType {Error, Information, Warning};
};

/**
 * @brief A custom widget for displaying status messages with icons.
 *
 * The DMessageLabel combines a text label with an icon (corresponding to the
 * MessageType) to provide visual feedback to the user (e.g., success messages,
 * validation errors, warnings).
 */
class DMessageLabel : public QWidget
{
  Q_OBJECT

public:
  /**
   * @brief Constructs the DMessageLabel.
   * @param type The severity type of the message (Error, Information, Warning).
   * @param message The initial text to display.
   */
  DMessageLabel(MessageTypes::MessageType type, QString message = QString());

  /**
   * @brief Sets the enabled state of the widget.
   *
   * Can be used to toggle the visibility or active state of the message.
   * @param enabled True to enable the widget, false to disable it.
   */
  void setEnabled(bool enabled);

  /**
   * @brief Updates the text displayed by the label.
   * @param message The new message string to display.
   */
  void setText(QString message = QString());

private:
  QLabel *icon;
  QLabel *label;
};

#endif // DMESSAGELABEL_H
