/*****************************************************************************
*
* This file is part of Calíope.
* Copyright (c) 2008-2026 David Villalobos Cambronero (david.villalobos.c@gmail.com).
*
* Calíope is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* Calíope is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
*
*****************************************************************************/

#ifndef DMDISUBWINDOW_H
#define DMDISUBWINDOW_H

#include <QMdiSubWindow>

/**
 * @brief The DMdiSubWindow class serves as the base class for all MDI subwindows.
 *
 * This class extends QMdiSubWindow to provide common functionality across the
 * application, such as dynamic UI retranslation support and standardized
 * close event handling.
 */
class DMdiSubWindow : public QMdiSubWindow
{
  Q_OBJECT

signals:
  /**
   * @brief Emitted when the window is closed.
   *
   * This signal allows the main window or parent container to perform cleanup
   * or update the list of active windows.
   */
  void windowClosed();

public:
  /**
   * @brief Constructs the DMdiSubWindow.
   */
  DMdiSubWindow();

  /**
   * @brief Retranslates the user interface.
   *
   * This virtual method is a hook for handling dynamic language changes.
   * Derived classes should override this to update widget text (e.g., labels,
   * buttons) when the application language is switched.
   */
  virtual void retranslateUI() {}

  /**
   * @brief Handles the window close event.
   *
   * Overrides the standard close event to emit the windowClosed() signal
   * and perform any necessary teardown logic.
   *
   * @param closeEvent The event parameters associated with the close request.
   */
  virtual void closeEvent(QCloseEvent *closeEvent);
};

#endif // DMDISUBWINDOW_H
